/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.overlay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.index.OverlayMergeIterator;

public class MultiOverlayTree<K, V> {
    private final V nullValue;
    private Comparator<K> comparator;
    private int overlayId;
    private Map<Integer, OverlayTreeList<K, V>> overlayMap;
    private OverlayTreeList<K, V> treeList;

    public MultiOverlayTree(V nullValue) {
        this(nullValue, null);
    }

    public MultiOverlayTree(V nullValue, Comparator<K> comparator) {
        this.comparator = comparator == null ? new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        } : comparator;
        this.treeList = new OverlayTreeList(new TreeMap(comparator), null);
        this.overlayMap = Collections.synchronizedMap(new HashMap());
        this.nullValue = nullValue;
    }

    public int newOverlay() {
        this.overlayMap.put(this.overlayId, this.treeList);
        this.treeList = new OverlayTreeList(new TreeMap(this.comparator), this.treeList);
        return this.overlayId++;
    }

    public void cleanup() {
        this.overlayMap.clear();
        this.treeList.next = null;
        this.overlayId = 0;
    }

    public void insert(K key, V value) {
        if (value == null) {
            this.treeList.tree.put(key, this.nullValue);
        } else {
            this.treeList.tree.put(key, value);
        }
    }

    public V lookup(K key) {
        return this.lookup(key, this.treeList);
    }

    public V lookup(K key, int overlayId) {
        return this.lookup(key, this.overlayMap.get(overlayId));
    }

    public ResultSet<K, V> rangeLookup(K from, K to, boolean includeDeletedEntries, boolean ascending) {
        return this.rangeLookup(from, to, this.treeList, includeDeletedEntries, ascending);
    }

    public ResultSet<K, V> rangeLookup(K from, K to, int overlayId, boolean includeDeletedEntries, boolean ascending) {
        return this.rangeLookup(from, to, this.overlayMap.get(overlayId), includeDeletedEntries, ascending);
    }

    private V lookup(K key, OverlayTreeList<K, V> list) {
        while (list != null) {
            Object value = list.tree.get(key);
            if (value != null) {
                return value;
            }
            list = list.next;
        }
        return null;
    }

    private ResultSet<K, V> rangeLookup(K from, K to, OverlayTreeList<K, V> treeList, boolean includeDeletedEntries, boolean ascending) {
        ArrayList itList = new ArrayList();
        OverlayTreeList<K, V> list = treeList;
        while (list != null) {
            if (from != null && to != null) {
                if (ascending) {
                    itList.add(list.tree.subMap(from, to).entrySet().iterator());
                } else {
                    itList.add(list.tree.descendingMap().subMap(from, to).entrySet().iterator());
                }
            } else if (from == null && to == null) {
                if (ascending) {
                    itList.add(list.tree.entrySet().iterator());
                } else {
                    itList.add(list.tree.descendingMap().entrySet().iterator());
                }
            } else if (from != null && to == null) {
                if (ascending) {
                    itList.add(list.tree.tailMap(from).entrySet().iterator());
                } else {
                    itList.add(list.tree.descendingMap().tailMap(from).entrySet().iterator());
                }
            } else if (ascending) {
                itList.add(list.tree.headMap(to).entrySet().iterator());
            } else {
                itList.add(list.tree.descendingMap().headMap(to).entrySet().iterator());
            }
            list = list.next;
        }
        return new OverlayMergeIterator(itList, this.comparator, (includeDeletedEntries ? null : (Object)this.nullValue), ascending);
    }

    static class OverlayTreeList<K, V> {
        public TreeMap<K, V> tree;
        public OverlayTreeList<K, V> next;

        public OverlayTreeList(TreeMap<K, V> tree, OverlayTreeList<K, V> next) {
            this.tree = tree;
            this.next = next;
        }
    }
}

