/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.nio.ByteBuffer;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.DefaultBlockReader;
import org.xtreemfs.babudb.index.reader.MiniPage;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public abstract class BlockReader {
    protected ByteBuffer buffer;
    protected ReusableBuffer readBuffer;
    protected int position;
    protected int limit;
    protected ByteRangeComparator comp;
    protected MiniPage keys;
    protected MiniPage values;
    protected int numEntries;
    protected final boolean isBuffered;

    protected BlockReader(boolean isBuffered) {
        this.isBuffered = isBuffered;
    }

    public BlockReader clone() {
        assert (this.isBuffered);
        this.buffer.position(0);
        return new DefaultBlockReader(this.buffer.slice(), this.position, this.limit, this.comp);
    }

    public abstract ByteRange lookup(byte[] var1);

    public abstract ResultSet<ByteRange, ByteRange> rangeLookup(byte[] var1, byte[] var2, boolean var3);

    public MiniPage getKeys() {
        return this.keys;
    }

    public MiniPage getValues() {
        return this.values;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public void free() {
        if (this.readBuffer != null) {
            BufferPool.free((ReusableBuffer)this.readBuffer);
        }
    }
}

