/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.BlockReader;
import org.xtreemfs.babudb.index.reader.FixedLenMiniPage;
import org.xtreemfs.babudb.index.reader.VarLenMiniPage;
import org.xtreemfs.foundation.buffer.BufferPool;

public class CompressedBlockReader
extends BlockReader {
    public static final int PREFIX_OFFSET = 20;
    private byte[] prefix;

    public CompressedBlockReader(ByteBuffer buf, int position, int limit, ByteRangeComparator comp) {
        super(true);
        this.buffer = buf;
        this.position = position;
        this.limit = limit;
        this.comp = comp;
        int valsOffset = position + buf.getInt(position);
        int keysOffset = position + buf.getInt(position + 4);
        this.numEntries = buf.getInt(position + 8);
        int keyEntrySize = buf.getInt(position + 12);
        int valEntrySize = buf.getInt(position + 16);
        int prefixSize = keysOffset - position - 20;
        this.prefix = new byte[prefixSize];
        if (prefixSize > 0) {
            buf.position(position + 20);
            buf.get(this.prefix);
            buf.position(position);
        }
        this.keys = keyEntrySize == -1 ? new VarLenMiniPage(this.numEntries, buf, keysOffset, valsOffset, comp) : new FixedLenMiniPage(keyEntrySize, this.numEntries, buf, keysOffset, valsOffset, comp);
        this.values = valEntrySize == -1 ? new VarLenMiniPage(this.numEntries, buf, valsOffset, limit, comp) : new FixedLenMiniPage(valEntrySize, this.numEntries, buf, valsOffset, limit, comp);
    }

    public CompressedBlockReader(FileChannel channel, int position, int limit, ByteRangeComparator comp) throws IOException {
        super(false);
        this.readBuffer = BufferPool.allocate((int)(limit - position));
        channel.read(this.readBuffer.getBuffer(), position);
        this.position = position;
        this.limit = limit;
        this.comp = comp;
        int valsOffset = this.readBuffer.getBuffer().getInt(0);
        int keysOffset = this.readBuffer.getBuffer().getInt(4);
        this.numEntries = this.readBuffer.getBuffer().getInt(8);
        int keyEntrySize = this.readBuffer.getBuffer().getInt(12);
        int valEntrySize = this.readBuffer.getBuffer().getInt(16);
        int prefixSize = keysOffset - 20;
        this.prefix = new byte[prefixSize];
        if (prefixSize > 0) {
            this.readBuffer.getBuffer().position(20);
            this.readBuffer.getBuffer().get(this.prefix);
            this.readBuffer.getBuffer().position(0);
        }
        this.keys = keyEntrySize == -1 ? new VarLenMiniPage(this.numEntries, this.readBuffer.getBuffer(), keysOffset, valsOffset, comp) : new FixedLenMiniPage(keyEntrySize, this.numEntries, this.readBuffer.getBuffer(), keysOffset, valsOffset, comp);
        this.values = valEntrySize == -1 ? new VarLenMiniPage(this.numEntries, this.readBuffer.getBuffer(), valsOffset, limit - position, comp) : new FixedLenMiniPage(valEntrySize, this.numEntries, this.readBuffer.getBuffer(), valsOffset, limit - position, comp);
    }

    private byte[] usableSuffix(byte[] key) {
        if (key == null || this.prefix.length > key.length) {
            return null;
        }
        if (this.prefix.length == 0) {
            return key;
        }
        byte[] prefixKey = new byte[this.prefix.length];
        System.arraycopy(key, 0, prefixKey, 0, this.prefix.length);
        if (this.comp.compare(this.prefix, prefixKey) != 0) {
            return null;
        }
        byte[] suffixKey = new byte[key.length - this.prefix.length];
        System.arraycopy(key, this.prefix.length, suffixKey, 0, key.length - this.prefix.length);
        return suffixKey;
    }

    @Override
    public ByteRange lookup(byte[] key) {
        byte[] suffixKey = this.usableSuffix(key);
        if (suffixKey == null) {
            return null;
        }
        int index = this.keys.getPosition(suffixKey);
        if (index == -1) {
            return null;
        }
        return this.values.getEntry(index);
    }

    @Override
    public ResultSet<ByteRange, ByteRange> rangeLookup(byte[] from, byte[] to, final boolean ascending) {
        int endIndex;
        int startIndex;
        byte[] suffixFrom = this.usableSuffix(from);
        int n = startIndex = ascending ? this.keys.getInclTopPosition(suffixFrom) : this.keys.getExclTopPosition(suffixFrom);
        assert (startIndex >= -1) : "invalid block start offset: " + startIndex;
        byte[] suffixTo = this.usableSuffix(to);
        int n2 = endIndex = ascending ? this.keys.getExclBottomPosition(suffixTo) : this.keys.getInclBottomPosition(suffixTo);
        assert (endIndex >= -1) : "invalid block end offset: " + endIndex;
        return new ResultSet<ByteRange, ByteRange>(){
            int currentIndex;
            {
                this.currentIndex = ascending ? startIndex : endIndex;
            }

            @Override
            public boolean hasNext() {
                return ascending ? this.currentIndex <= endIndex : this.currentIndex >= startIndex;
            }

            @Override
            public Map.Entry<ByteRange, ByteRange> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<ByteRange, ByteRange> entry = new Map.Entry<ByteRange, ByteRange>(){
                    final ByteRange key;
                    final ByteRange value;
                    {
                        boolean last;
                        this.key = CompressedBlockReader.this.keys.getEntry(currentIndex);
                        this.value = CompressedBlockReader.this.values.getEntry(currentIndex);
                        boolean bl = !(!ascending ? currentIndex > startIndex : currentIndex < endIndex) ? true : (last = false);
                        if (last) {
                            this.value.setReusableBuf(CompressedBlockReader.this.readBuffer);
                        }
                    }

                    @Override
                    public ByteRange getValue() {
                        return this.value;
                    }

                    @Override
                    public ByteRange getKey() {
                        this.key.addPrefix(CompressedBlockReader.this.prefix);
                        return this.key;
                    }

                    @Override
                    public ByteRange setValue(ByteRange value) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.currentIndex = ascending ? ++this.currentIndex : --this.currentIndex;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void free() {
            }
        };
    }
}

