/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.BlockReader;
import org.xtreemfs.babudb.index.reader.FixedLenMiniPage;
import org.xtreemfs.babudb.index.reader.VarLenMiniPage;
import org.xtreemfs.foundation.buffer.BufferPool;

public class DefaultBlockReader
extends BlockReader {
    public static final int KEYS_OFFSET = 16;

    public DefaultBlockReader(ByteBuffer buf, int position, int limit, ByteRangeComparator comp) {
        super(true);
        this.buffer = buf;
        this.position = position;
        this.limit = limit;
        this.comp = comp;
        if (limit > 0) {
            int keysOffset = position + 16;
            int valsOffset = position + buf.getInt(position);
            this.numEntries = buf.getInt(position + 4);
            int keyEntrySize = buf.getInt(position + 8);
            int valEntrySize = buf.getInt(position + 12);
            this.keys = keyEntrySize == -1 ? new VarLenMiniPage(this.numEntries, buf, keysOffset, valsOffset, comp) : new FixedLenMiniPage(keyEntrySize, this.numEntries, buf, keysOffset, valsOffset, comp);
            this.values = valEntrySize == -1 ? new VarLenMiniPage(this.numEntries, buf, valsOffset, limit, comp) : new FixedLenMiniPage(valEntrySize, this.numEntries, buf, valsOffset, limit, comp);
        } else {
            this.numEntries = 0;
            this.keys = new FixedLenMiniPage(0, 0, null, 0, 0, comp);
            this.values = new FixedLenMiniPage(0, 0, null, 0, 0, comp);
        }
    }

    public DefaultBlockReader(FileChannel channel, int position, int limit, ByteRangeComparator comp) throws IOException {
        super(false);
        this.position = position;
        this.limit = limit;
        this.comp = comp;
        this.readBuffer = BufferPool.allocate((int)(limit - position));
        channel.read(this.readBuffer.getBuffer(), position);
        if (limit > 0) {
            int keysOffset = 16;
            int valsOffset = this.readBuffer.getBuffer().getInt(0);
            this.numEntries = this.readBuffer.getBuffer().getInt(4);
            int keyEntrySize = this.readBuffer.getBuffer().getInt(8);
            int valEntrySize = this.readBuffer.getBuffer().getInt(12);
            this.keys = keyEntrySize == -1 ? new VarLenMiniPage(this.numEntries, this.readBuffer.getBuffer(), keysOffset, valsOffset, comp) : new FixedLenMiniPage(keyEntrySize, this.numEntries, this.readBuffer.getBuffer(), keysOffset, valsOffset, comp);
            this.values = valEntrySize == -1 ? new VarLenMiniPage(this.numEntries, this.readBuffer.getBuffer(), valsOffset, limit - position, comp) : new FixedLenMiniPage(valEntrySize, this.numEntries, this.readBuffer.getBuffer(), valsOffset, limit - position, comp);
        } else {
            this.numEntries = 0;
            this.keys = new FixedLenMiniPage(0, 0, null, 0, 0, comp);
            this.values = new FixedLenMiniPage(0, 0, null, 0, 0, comp);
        }
    }

    @Override
    public ByteRange lookup(byte[] key) {
        int index = this.keys.getPosition(key);
        if (index == -1) {
            return null;
        }
        return this.values.getEntry(index);
    }

    @Override
    public ResultSet<ByteRange, ByteRange> rangeLookup(byte[] from, byte[] to, final boolean ascending) {
        int endIndex;
        int startIndex;
        int n = startIndex = ascending ? this.keys.getInclTopPosition(from) : this.keys.getExclTopPosition(from);
        assert (startIndex >= -1) : "invalid block start offset: " + startIndex;
        int n2 = endIndex = ascending ? this.keys.getExclBottomPosition(to) : this.keys.getInclBottomPosition(to);
        assert (endIndex >= -1) : "invalid block end offset: " + endIndex;
        return new ResultSet<ByteRange, ByteRange>(){
            int currentIndex;
            {
                this.currentIndex = ascending ? startIndex : endIndex;
            }

            @Override
            public boolean hasNext() {
                return ascending ? this.currentIndex <= endIndex : this.currentIndex >= startIndex;
            }

            @Override
            public Map.Entry<ByteRange, ByteRange> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<ByteRange, ByteRange> entry = new Map.Entry<ByteRange, ByteRange>(){
                    final ByteRange key;
                    final ByteRange value;
                    {
                        boolean last;
                        this.key = DefaultBlockReader.this.keys.getEntry(currentIndex);
                        this.value = DefaultBlockReader.this.values.getEntry(currentIndex);
                        boolean bl = !(!ascending ? currentIndex > startIndex : currentIndex < endIndex) ? true : (last = false);
                        if (last) {
                            this.value.setReusableBuf(DefaultBlockReader.this.readBuffer);
                        }
                    }

                    @Override
                    public ByteRange getValue() {
                        return this.value;
                    }

                    @Override
                    public ByteRange getKey() {
                        return this.key;
                    }

                    @Override
                    public ByteRange setValue(ByteRange value) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.currentIndex = ascending ? ++this.currentIndex : --this.currentIndex;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void free() {
            }
        };
    }
}

