/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.BlockReader;
import org.xtreemfs.babudb.index.reader.DiskIndex;
import org.xtreemfs.babudb.index.reader.DiskIndexIteratorBase;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class DiskIndexIterator
extends DiskIndexIteratorBase
implements ResultSet<byte[], byte[]> {
    public DiskIndexIterator(DiskIndex index, BlockReader blockIndexReader, byte[] from, byte[] to, boolean ascending, ByteBuffer[] maps) {
        super(index, blockIndexReader, from, to, ascending, maps, null);
    }

    public DiskIndexIterator(DiskIndex index, BlockReader blockIndexReader, byte[] from, byte[] to, boolean ascending, FileChannel[] dbFileChannels) {
        super(index, blockIndexReader, from, to, ascending, null, dbFileChannels);
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        final Map.Entry entry = (Map.Entry)this.currentBlockIterator.next();
        return new Map.Entry<byte[], byte[]>(){
            private byte[] key;
            private byte[] value;
            {
                this.key = ((ByteRange)entry.getKey()).toBuffer();
                this.value = ((ByteRange)entry.getValue()).toBuffer();
                if (((ByteRange)entry.getValue()).getReusableBuf() != null) {
                    BufferPool.free((ReusableBuffer)((ByteRange)entry.getValue()).getReusableBuf());
                }
            }

            @Override
            public byte[] getKey() {
                return this.key;
            }

            @Override
            public byte[] getValue() {
                return this.value;
            }

            @Override
            public byte[] setValue(byte[] value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

