/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Map;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.BlockReader;
import org.xtreemfs.babudb.index.reader.DiskIndex;
import org.xtreemfs.foundation.logging.Logging;

public abstract class DiskIndexIteratorBase {
    private final DiskIndex index;
    private final byte[] from;
    private final byte[] to;
    private final BlockReader blockIndexReader;
    private final ByteBuffer[] maps;
    private final FileChannel[] dbFileChannels;
    private final int blockIndexStart;
    private final int blockIndexEnd;
    private final boolean ascending;
    private int currentBlockIndex;
    private BlockReader currentBlock;
    protected Iterator<Map.Entry<ByteRange, ByteRange>> currentBlockIterator;

    protected DiskIndexIteratorBase(DiskIndex index, BlockReader blockIndexReader, byte[] from, byte[] to, boolean ascending, ByteBuffer[] maps, FileChannel[] dbFileChannels) {
        int tmp;
        this.maps = maps;
        this.dbFileChannels = dbFileChannels;
        this.index = index;
        this.from = from;
        this.to = to;
        this.ascending = ascending;
        this.blockIndexReader = blockIndexReader.clone();
        int n = tmp = from == null ? 0 : index.getBlockIndexPosition(from, blockIndexReader);
        if (tmp < 0) {
            tmp = 0;
        }
        this.blockIndexStart = tmp;
        int n2 = tmp = to == null ? blockIndexReader.getNumEntries() - 1 : index.getBlockIndexPosition(to, blockIndexReader);
        if (tmp > blockIndexReader.getNumEntries() - 1) {
            tmp = blockIndexReader.getNumEntries() - 1;
        }
        this.blockIndexEnd = tmp;
        this.currentBlockIndex = ascending ? this.blockIndexStart : this.blockIndexEnd;
        this.getNextBlockData();
    }

    public boolean hasNext() {
        while (this.currentBlockIterator != null) {
            if (this.currentBlockIterator.hasNext()) {
                return true;
            }
            this.currentBlockIndex = this.ascending ? ++this.currentBlockIndex : --this.currentBlockIndex;
            this.getNextBlockData();
        }
        return false;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void free() {
        if (this.currentBlock != null && this.currentBlock.readBuffer != null && this.currentBlock.readBuffer.getRefCount() > 0) {
            this.currentBlock.free();
        }
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    private void getNextBlockData() {
        int endOffset;
        if (this.blockIndexStart == -1 && this.blockIndexEnd == -1) {
            return;
        }
        if (this.ascending && this.currentBlockIndex > this.blockIndexEnd) {
            this.currentBlock = null;
            this.currentBlockIterator = null;
            return;
        }
        if (!this.ascending && this.currentBlockIndex < this.blockIndexStart) {
            this.currentBlock = null;
            this.currentBlockIterator = null;
            return;
        }
        int startOffset = DiskIndex.getBlockOffset(this.currentBlockIndex, this.blockIndexReader);
        short fileId = DiskIndex.getBlockFileId(this.currentBlockIndex, this.blockIndexReader);
        if (this.currentBlockIndex == this.blockIndexReader.getNumEntries() - 1) {
            endOffset = -1;
        } else {
            ByteRange indexPos = DiskIndex.getBlockEntry(this.currentBlockIndex + 1, this.blockIndexReader);
            ByteBuffer indexPosBuf = indexPos.getBuf();
            endOffset = DiskIndex.getBlockIndexOffset(indexPosBuf, indexPos.getStartOffset());
            if (DiskIndex.getBlockIndexFileId(indexPosBuf, indexPos.getStartOffset()) > fileId) {
                endOffset = -1;
            }
        }
        try {
            this.currentBlock = this.maps != null ? this.index.getBlock(startOffset, endOffset, this.maps[fileId]) : this.index.getBlock(startOffset, endOffset, this.dbFileChannels[fileId]);
        }
        catch (ClosedByInterruptException exc) {
            Logging.logError((int)7, (Object)this, (Throwable)exc);
        }
        catch (IOException exc) {
            Logging.logError((int)3, (Object)this, (Throwable)exc);
        }
        this.currentBlockIterator = this.currentBlock == null ? null : this.currentBlock.rangeLookup(this.from == null ? null : this.from, this.to == null ? null : this.to, this.ascending);
    }
}

