/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.nio.ByteBuffer;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.MiniPage;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.util.OutputUtils;

public class FixedLenMiniPage
extends MiniPage {
    private final int entrySize;
    private final int limit;

    public FixedLenMiniPage(int entrySize, int numEntries, ByteBuffer buf, int offset, int limit, ByteRangeComparator comp) {
        super(numEntries, buf, offset, comp);
        this.entrySize = entrySize;
        this.limit = limit;
    }

    @Override
    public ByteRange getEntry(int n) {
        assert (this.offset < this.buf.limit()) : "offset == " + this.offset + ", buf.limit == " + this.buf.limit() + ", entrySize == " + this.entrySize + ", n == " + n;
        return new ByteRange(this.buf, this.offset + n * this.entrySize, this.offset + (n + 1) * this.entrySize - 1);
    }

    public String toString() {
        this.buf.position(this.offset);
        this.buf.limit(this.limit);
        ReusableBuffer newBuf = BufferPool.allocate((int)(this.limit - this.buf.position()));
        newBuf.put(this.buf);
        String result = OutputUtils.byteArrayToFormattedHexString((byte[])newBuf.array());
        BufferPool.free((ReusableBuffer)newBuf);
        this.buf.clear();
        return result;
    }
}

