/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.util.Map;
import org.xtreemfs.babudb.index.ByteRange;

public class InternalBufferUtil {
    public static byte[] toBuffer(Object buf) {
        if (buf instanceof byte[]) {
            return (byte[])buf;
        }
        return ((ByteRange)buf).toBuffer();
    }

    public static int size(Object buf) {
        if (buf instanceof byte[]) {
            return ((byte[])buf).length;
        }
        return ((ByteRange)buf).getSize();
    }

    public static byte byteAt(Object buf, int offset) {
        if (buf instanceof byte[]) {
            return ((byte[])buf)[offset];
        }
        ByteRange range = (ByteRange)buf;
        assert (range.getSize() <= offset);
        return range.getBuf().get(range.getStartOffset() + offset);
    }

    public static Map.Entry<Object, Object> cast(final Map.Entry<?, ?> byteEntry) {
        Map.Entry<Object, Object> entry = new Map.Entry<Object, Object>(){

            @Override
            public Object getKey() {
                return byteEntry.getKey();
            }

            @Override
            public Object getValue() {
                return byteEntry.getValue();
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        };
        return entry;
    }
}

