/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.InternalBufferUtil;
import org.xtreemfs.babudb.index.reader.InternalDiskIndexIterator;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class InternalMergeIterator
implements ResultSet<Object, Object> {
    private Iterator<Map.Entry<byte[], byte[]>> overlayIterator;
    private InternalDiskIndexIterator diskIndexIterator;
    private Map.Entry<byte[], byte[]> nextOverlayEntry;
    private Map.Entry<ByteRange, ByteRange> nextDiskIndexEntry;
    private Map.Entry<Object, Object> nextEntry;
    private ByteRangeComparator comp;
    private byte[] nullValue;
    private boolean ascending;

    public InternalMergeIterator(Iterator<Map.Entry<byte[], byte[]>> overlayIterator, InternalDiskIndexIterator diskIndexIterator, ByteRangeComparator comp, byte[] nullValue, boolean ascending) {
        assert (overlayIterator != null);
        this.overlayIterator = overlayIterator;
        this.diskIndexIterator = diskIndexIterator;
        this.comp = comp;
        this.nullValue = nullValue;
        this.ascending = ascending;
        this.nextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public Map.Entry<Object, Object> next() {
        if (this.nextEntry == null) {
            throw new NoSuchElementException();
        }
        Map.Entry<Object, Object> tmp = this.nextEntry;
        this.nextElement();
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() {
        if (this.diskIndexIterator != null) {
            this.diskIndexIterator.free();
        }
    }

    private void nextElement() {
        do {
            if (this.nextOverlayEntry == null && this.overlayIterator.hasNext()) {
                this.nextOverlayEntry = this.overlayIterator.next();
            }
            if (this.nextDiskIndexEntry == null && this.diskIndexIterator != null && this.diskIndexIterator.hasNext()) {
                this.nextDiskIndexEntry = this.diskIndexIterator.next();
            }
            if (this.nextOverlayEntry != null && this.nextDiskIndexEntry != null && this.comp.compare(this.nextDiskIndexEntry.getKey(), this.nextOverlayEntry.getKey()) == 0) {
                if (this.nextDiskIndexEntry.getValue().getReusableBuf() != null) {
                    BufferPool.free((ReusableBuffer)this.nextDiskIndexEntry.getValue().getReusableBuf());
                }
                this.nextDiskIndexEntry = this.diskIndexIterator.hasNext() ? this.diskIndexIterator.next() : null;
            }
            if (this.nextDiskIndexEntry == null && this.nextOverlayEntry == null) {
                this.nextEntry = null;
                return;
            }
            if (this.ascending) {
                if (this.nextDiskIndexEntry == null) {
                    this.nextEntry = InternalBufferUtil.cast(this.nextOverlayEntry);
                    this.nextOverlayEntry = null;
                } else if (this.nextOverlayEntry == null) {
                    this.nextEntry = InternalBufferUtil.cast(this.nextDiskIndexEntry);
                    this.nextDiskIndexEntry = null;
                } else if (this.comp.compare(this.nextDiskIndexEntry.getKey(), this.nextOverlayEntry.getKey()) < 0) {
                    this.nextEntry = InternalBufferUtil.cast(this.nextDiskIndexEntry);
                    this.nextDiskIndexEntry = null;
                } else {
                    this.nextEntry = InternalBufferUtil.cast(this.nextOverlayEntry);
                    this.nextOverlayEntry = null;
                }
            } else if (this.nextDiskIndexEntry == null) {
                this.nextEntry = InternalBufferUtil.cast(this.nextOverlayEntry);
                this.nextOverlayEntry = null;
            } else if (this.nextOverlayEntry == null) {
                this.nextEntry = InternalBufferUtil.cast(this.nextDiskIndexEntry);
                this.nextDiskIndexEntry = null;
            } else if (this.comp.compare(this.nextDiskIndexEntry.getKey(), this.nextOverlayEntry.getKey()) > 0) {
                this.nextEntry = InternalBufferUtil.cast(this.nextDiskIndexEntry);
                this.nextDiskIndexEntry = null;
            } else {
                InternalBufferUtil.cast(this.nextOverlayEntry);
                this.nextOverlayEntry = null;
            }
            assert (this.nextEntry != null);
        } while (this.nullValue != null && this.nextEntry.getValue() == this.nullValue);
    }
}

