/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.nio.ByteBuffer;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.SearchUtil;

public abstract class MiniPage {
    protected int numEntries;
    protected ByteBuffer buf;
    protected final int offset;
    protected final ByteRangeComparator comp;

    public MiniPage(int numEntries, ByteBuffer buf, int offset, ByteRangeComparator comp) {
        assert (offset <= buf.limit()) : "invalid mini page offset: offset == " + offset + ", buf.limit() == " + buf.limit();
        assert (offset != buf.limit() || numEntries == 0) : "invalid mini page offset: offset == " + offset + ", buf.limit() == " + buf.limit();
        this.numEntries = numEntries;
        this.buf = buf;
        this.offset = offset;
        this.comp = comp;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public abstract ByteRange getEntry(int var1);

    public int getPosition(byte[] entry) {
        return SearchUtil.getOffset(this, entry, this.comp);
    }

    public int getExclTopPosition(byte[] entry) {
        if (entry == null) {
            return 0;
        }
        return SearchUtil.getExclTopOffset(this, entry, this.comp);
    }

    public int getInclTopPosition(byte[] entry) {
        if (entry == null) {
            return 0;
        }
        return SearchUtil.getInclTopOffset(this, entry, this.comp);
    }

    public int getExclBottomPosition(byte[] entry) {
        if (entry == null) {
            return this.numEntries - 1;
        }
        return SearchUtil.getExclBottomOffset(this, entry, this.comp);
    }

    public int getInclBottomPosition(byte[] entry) {
        if (entry == null) {
            return this.numEntries - 1;
        }
        return SearchUtil.getInclBottomOffset(this, entry, this.comp);
    }
}

