/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.MiniPage;

public class SearchUtil {
    public static int getInclBottomOffset(MiniPage page, byte[] entry, ByteRangeComparator comp) {
        int high;
        assert (page.getNumEntries() >= 0) : "invalid number of page entries: " + page.getNumEntries();
        int low = 0;
        int mid = high = page.getNumEntries() - 1;
        int cmp = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            ByteRange currKey = page.getEntry(mid);
            cmp = comp.compare(currKey, entry);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return cmp > 0 ? mid - 1 : mid;
    }

    public static int getExclBottomOffset(MiniPage page, byte[] entry, ByteRangeComparator comp) {
        int high;
        assert (page.getNumEntries() >= 0) : "invalid number of page entries: " + page.getNumEntries();
        int low = 0;
        int mid = high = page.getNumEntries() - 1;
        int cmp = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            ByteRange currKey = page.getEntry(mid);
            cmp = comp.compare(currKey, entry);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid - 1;
        }
        return cmp > 0 ? mid - 1 : mid;
    }

    public static int getInclTopOffset(MiniPage page, byte[] entry, ByteRangeComparator comp) {
        int high;
        assert (page.getNumEntries() >= 0) : "invalid number of page entries: " + page.getNumEntries();
        int low = 0;
        int mid = high = page.getNumEntries() - 1;
        int cmp = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            ByteRange currKey = page.getEntry(mid);
            cmp = comp.compare(currKey, entry);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return cmp > 0 ? mid : mid + 1;
    }

    public static int getExclTopOffset(MiniPage page, byte[] entry, ByteRangeComparator comp) {
        int high;
        assert (page.getNumEntries() >= 0) : "invalid number of page entries: " + page.getNumEntries();
        int low = 0;
        int mid = high = page.getNumEntries() - 1;
        int cmp = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            ByteRange currKey = page.getEntry(mid);
            cmp = comp.compare(currKey, entry);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid + 1;
        }
        return cmp > 0 ? mid : mid + 1;
    }

    public static int getOffset(MiniPage page, byte[] entry, ByteRangeComparator comp) {
        int high;
        assert (page.getNumEntries() >= 0) : "invalid number of page entries: " + page.getNumEntries();
        int low = 0;
        int mid = high = page.getNumEntries() - 1;
        int cmp = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            ByteRange currKey = page.getEntry(mid);
            cmp = comp.compare(currKey, entry);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }
}

