/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.reader;

import java.nio.ByteBuffer;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.MiniPage;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.util.OutputUtils;

public class VarLenMiniPage
extends MiniPage {
    private final int offsetListStart;

    public VarLenMiniPage(int numEntries, ByteBuffer buf, int offset, int limit, ByteRangeComparator comp) {
        super(numEntries, buf, offset, comp);
        this.offsetListStart = limit - numEntries * 32 / 8;
    }

    @Override
    public ByteRange getEntry(int n) {
        int offsetStart = this.offset;
        if (n > 0) {
            offsetStart += this.buf.getInt(this.offsetListStart + (n - 1) * 32 / 8);
        }
        int offsetEnd = this.offset;
        assert ((offsetEnd += this.buf.getInt(this.offsetListStart + n * 32 / 8)) > offsetStart);
        return new ByteRange(this.buf, offsetStart, offsetEnd);
    }

    public String toString() {
        this.buf.position(this.offset);
        this.buf.limit(this.offsetListStart + this.numEntries * 32 / 8);
        ReusableBuffer newBuf = BufferPool.allocate((int)(this.buf.limit() - this.buf.position()));
        newBuf.put(this.buf);
        String result = OutputUtils.byteArrayToFormattedHexString((byte[])newBuf.array());
        BufferPool.free((ReusableBuffer)newBuf);
        this.buf.clear();
        return result;
    }
}

