/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.writer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.InternalBufferUtil;
import org.xtreemfs.babudb.index.writer.BlockWriter;
import org.xtreemfs.babudb.index.writer.SerializedBlock;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class CompressedBlockWriter
implements BlockWriter {
    private List<Object> keys = new LinkedList<Object>();
    private List<Object> values = new LinkedList<Object>();
    private boolean varLenKeys;
    private boolean varLenVals;
    private byte[] prefix;

    public CompressedBlockWriter(boolean varLenKeys, boolean varLenVals) {
        this.varLenKeys = varLenKeys;
        this.varLenVals = varLenVals;
    }

    @Override
    public void add(Object key, Object value) {
        this.keys.add(key);
        this.values.add(value);
    }

    @Override
    public SerializedBlock serialize() {
        List<byte[]> compressedKeys = this.compress(this.keys);
        ReusableBuffer keyBuf = this.varLenKeys ? CompressedBlockWriter.serializeVarLenPageBuf(compressedKeys) : CompressedBlockWriter.serializeFixedLenPage(this.keys);
        ReusableBuffer valBuf = this.varLenVals ? CompressedBlockWriter.serializeVarLenPage(this.values) : CompressedBlockWriter.serializeFixedLenPage(this.values);
        int entries = this.keys.size();
        int keysOffset = 20 + this.prefix.length;
        int valsOffset = keysOffset + keyBuf.limit();
        ByteBuffer returnBuf = ByteBuffer.wrap(new byte[valsOffset + valBuf.limit()]);
        returnBuf.putInt(valsOffset);
        returnBuf.putInt(keysOffset);
        returnBuf.putInt(entries);
        returnBuf.putInt(this.varLenKeys ? -1 : (entries == 0 ? 0 : keyBuf.limit() / entries));
        returnBuf.putInt(this.varLenVals ? -1 : (entries == 0 ? 0 : valBuf.limit() / entries));
        if (this.prefix.length > 0) {
            returnBuf.put(this.prefix);
        }
        returnBuf.put(keyBuf.getBuffer());
        returnBuf.put(valBuf.getBuffer());
        BufferPool.free((ReusableBuffer)keyBuf);
        BufferPool.free((ReusableBuffer)valBuf);
        returnBuf.position(0);
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        list.add(returnBuf.array());
        SerializedBlock block = new SerializedBlock();
        block.addBuffers(returnBuf.limit(), list);
        return block;
    }

    @Override
    public Object getBlockKey() {
        return this.keys.get(0);
    }

    private List<byte[]> compress(List<Object> list) {
        LinkedList<byte[]> results = new LinkedList<byte[]>();
        if (list.size() == 1) {
            this.prefix = new byte[0];
            ArrayList<byte[]> tmp = new ArrayList<byte[]>(1);
            Object buf = list.get(0);
            tmp.add(InternalBufferUtil.toBuffer(buf));
            return tmp;
        }
        Object prefix = list.get(0);
        int longestPrefixLen = InternalBufferUtil.size(prefix);
        for (Object entry : list) {
            int prefixLen;
            int prefixIndex = 0;
            int entryIndex = 0;
            int maxLen = Math.min(InternalBufferUtil.size(prefix), InternalBufferUtil.size(entry));
            for (prefixLen = 0; prefixLen < maxLen && InternalBufferUtil.byteAt(prefix, prefixIndex++) == InternalBufferUtil.byteAt(entry, entryIndex++); ++prefixLen) {
            }
            if (prefixLen >= longestPrefixLen) continue;
            longestPrefixLen = prefixLen;
        }
        byte[] LCP = new byte[longestPrefixLen];
        System.arraycopy(InternalBufferUtil.toBuffer(prefix), 0, LCP, 0, longestPrefixLen);
        this.prefix = LCP;
        for (Object entry : list) {
            if (longestPrefixLen <= 0) {
                results.add(InternalBufferUtil.toBuffer(entry));
                continue;
            }
            if (entry instanceof byte[]) {
                int newLen = ((byte[])entry).length - longestPrefixLen;
                byte[] newEntry = new byte[newLen];
                System.arraycopy((byte[])entry, longestPrefixLen, newEntry, 0, newLen);
                results.add(newEntry);
                continue;
            }
            ((ByteRange)entry).addPrefix(LCP);
            results.add(((ByteRange)entry).toBuffer());
        }
        return results;
    }

    private static ReusableBuffer serializeVarLenPageBuf(List<byte[]> list) {
        int[] offsets = new int[list.size()];
        int size = 0;
        int offsetPos = 0;
        for (byte[] buf : list) {
            offsets[offsetPos] = size += buf.length;
            ++offsetPos;
        }
        ReusableBuffer newBuf = BufferPool.allocate((int)(size += list.size() * 32 / 8));
        for (byte[] buf : list) {
            newBuf.put(buf);
        }
        for (int offs : offsets) {
            newBuf.putInt(offs);
        }
        newBuf.position(0);
        return newBuf;
    }

    private static ReusableBuffer serializeVarLenPage(List<Object> list) {
        int[] offsets = new int[list.size()];
        int size = 0;
        int offsetPos = 0;
        for (Object buf : list) {
            offsets[offsetPos] = size += InternalBufferUtil.size(buf);
            ++offsetPos;
        }
        ReusableBuffer newBuf = BufferPool.allocate((int)(size += list.size() * 32 / 8));
        for (Object buf : list) {
            newBuf.put(InternalBufferUtil.toBuffer(buf));
        }
        for (int offs : offsets) {
            newBuf.putInt(offs);
        }
        newBuf.position(0);
        return newBuf;
    }

    private static ReusableBuffer serializeFixedLenPage(List<Object> list) {
        int size = list.size() == 0 ? 0 : InternalBufferUtil.size(list.get(0)) * list.size();
        ReusableBuffer newBuf = BufferPool.allocate((int)size);
        for (Object buf : list) {
            newBuf.put(InternalBufferUtil.toBuffer(buf));
        }
        newBuf.position(0);
        return newBuf;
    }
}

