/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.writer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.xtreemfs.babudb.index.reader.InternalBufferUtil;
import org.xtreemfs.babudb.index.writer.BlockWriter;
import org.xtreemfs.babudb.index.writer.SerializedBlock;
import org.xtreemfs.babudb.index.writer.SerializedPage;

public class DefaultBlockWriter
implements BlockWriter {
    private List<Object> keys = new LinkedList<Object>();
    private List<Object> values = new LinkedList<Object>();
    private boolean varLenKeys;
    private boolean varLenVals;
    private boolean serialized;

    public DefaultBlockWriter(boolean varLenKeys, boolean varLenVals) {
        this.varLenKeys = varLenKeys;
        this.varLenVals = varLenVals;
    }

    @Override
    public void add(Object key, Object value) {
        if (this.serialized) {
            throw new UnsupportedOperationException("already serialized");
        }
        this.keys.add(key);
        this.values.add(value);
    }

    @Override
    public SerializedBlock serialize() {
        if (this.serialized) {
            throw new UnsupportedOperationException("already serialized");
        }
        this.serialized = true;
        SerializedPage keyPage = this.varLenKeys ? DefaultBlockWriter.serializeVarLenPage(this.keys) : DefaultBlockWriter.serializeFixedLenPage(this.keys);
        SerializedPage valPage = this.varLenVals ? DefaultBlockWriter.serializeVarLenPage(this.values) : DefaultBlockWriter.serializeFixedLenPage(this.values);
        int entries = this.keys.size();
        int valsOffset = 16 + keyPage.size;
        ByteBuffer tmp = ByteBuffer.wrap(new byte[16]);
        tmp.putInt(valsOffset);
        tmp.putInt(entries);
        tmp.putInt(this.varLenKeys ? -1 : (entries == 0 ? 0 : keyPage.size / entries));
        tmp.putInt(this.varLenVals ? -1 : (entries == 0 ? 0 : valPage.size / entries));
        ArrayList<byte[]> header = new ArrayList<byte[]>(1);
        header.add(tmp.array());
        SerializedBlock result = new SerializedBlock();
        result.addBuffers(tmp.limit(), header);
        result.addBuffers(keyPage.size, keyPage.entries);
        result.addBuffers(valPage.size, valPage.entries);
        return result;
    }

    @Override
    public Object getBlockKey() {
        return this.keys.get(0);
    }

    private static SerializedPage serializeVarLenPage(List<Object> list) {
        LinkedList<byte[]> offsetList = new LinkedList<byte[]>();
        int size = 0;
        for (Object buf : list) {
            ByteBuffer tmp = ByteBuffer.wrap(new byte[4]);
            tmp.putInt(size += InternalBufferUtil.size(buf));
            offsetList.add(tmp.array());
        }
        return new SerializedPage(size += list.size() * 32 / 8, list, offsetList);
    }

    private static SerializedPage serializeFixedLenPage(List<Object> list) {
        int size = 0;
        for (Object buf : list) {
            size += InternalBufferUtil.size(buf);
        }
        return new SerializedPage(size, list);
    }
}

