/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.index.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.index.ByteRange;
import org.xtreemfs.babudb.index.reader.InternalBufferUtil;
import org.xtreemfs.babudb.index.writer.BlockWriter;
import org.xtreemfs.babudb.index.writer.CompressedBlockWriter;
import org.xtreemfs.babudb.index.writer.DefaultBlockWriter;
import org.xtreemfs.babudb.index.writer.SerializedBlock;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class DiskIndexWriter {
    private String path;
    private int maxBlockEntries;
    private boolean compressed;
    private int maxFileSize;
    private short blockFileId;

    public DiskIndexWriter(String path, int maxBlockEntries, boolean compressed, int maxFileSize) throws IOException {
        if (!path.endsWith(System.getProperty("file.separator"))) {
            path = path + System.getProperty("file.separator");
        }
        assert (maxFileSize <= Integer.MAX_VALUE);
        File diDir = new File(path);
        if (diDir.exists()) {
            throw new IOException("index already exists");
        }
        if (!diDir.mkdirs()) {
            throw new IOException("could not create directory '" + path + "'");
        }
        this.compressed = compressed;
        this.path = path;
        this.maxBlockEntries = maxBlockEntries;
        this.maxFileSize = maxFileSize;
    }

    private void writeIndex(String path, BlockWriter blockIndex, Iterator<Map.Entry<Object, Object>> iterator) throws IOException {
        FileOutputStream out = new FileOutputStream(path);
        BlockWriter block = this.compressed ? new CompressedBlockWriter(true, true) : new DefaultBlockWriter(true, true);
        int entryCount = 0;
        int blockOffset = 0;
        boolean newBlockFile = false;
        while (iterator.hasNext() && !newBlockFile) {
            Map.Entry<Object, Object> next = iterator.next();
            block.add(next.getKey(), next.getValue());
            if (++entryCount % this.maxBlockEntries != 0 && iterator.hasNext()) continue;
            ReusableBuffer buf = ReusableBuffer.wrap((byte[])new byte[6]);
            buf.putInt(blockOffset);
            buf.putShort(this.blockFileId);
            blockIndex.add(InternalBufferUtil.toBuffer(block.getBlockKey()), buf.array());
            SerializedBlock serializedBlock = block.serialize();
            blockOffset += serializedBlock.size();
            int writtenBytes = 0;
            Iterator<Object> it = serializedBlock.iterator();
            while (it.hasNext()) {
                ByteRange rng;
                Object nextBuffer;
                if (!out.getFD().valid()) {
                    out.close();
                    out = new FileOutputStream(path, true);
                }
                if ((nextBuffer = it.next()) instanceof ByteRange && (rng = (ByteRange)nextBuffer).getReusableBuf() != null) {
                    BufferPool.free((ReusableBuffer)rng.getReusableBuf());
                }
                writtenBytes += this.writeBuffer(out, nextBuffer);
            }
            assert (writtenBytes == serializedBlock.size());
            if (blockOffset >= this.maxFileSize) {
                newBlockFile = true;
                continue;
            }
            if (!iterator.hasNext()) continue;
            if (this.compressed) {
                block = new CompressedBlockWriter(true, true);
                continue;
            }
            block = new DefaultBlockWriter(true, true);
        }
        out.close();
    }

    public void writeIndex(ResultSet<Object, Object> iterator) throws IOException {
        DefaultBlockWriter blockIndex = new DefaultBlockWriter(true, false);
        while (iterator.hasNext()) {
            String indexPath = this.path + "blockfile_" + new Short(this.blockFileId).toString() + ".idx";
            this.writeIndex(indexPath, blockIndex, iterator);
            this.blockFileId = (short)(this.blockFileId + 1);
        }
        iterator.free();
        new File(this.path + "blockindex.idx").createNewFile();
        FileOutputStream out = new FileOutputStream(this.path + "blockindex.idx", false);
        SerializedBlock serializedBuf = blockIndex.serialize();
        int bytesWritten = 0;
        Iterator<Object> it = serializedBuf.iterator();
        while (it.hasNext()) {
            bytesWritten += this.writeBuffer(out, it.next());
        }
        assert (bytesWritten == serializedBuf.size());
        out.close();
    }

    private int writeBuffer(FileOutputStream out, Object buf) throws IOException {
        if (buf instanceof byte[]) {
            byte[] bytes = (byte[])buf;
            out.write(bytes);
            return bytes.length;
        }
        ByteRange range = (ByteRange)buf;
        range.getBuf().position(range.getStartOffset());
        ByteBuffer slice = range.getBuf().slice();
        slice.limit(range.getSize());
        return out.getChannel().write(slice);
    }
}

