/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.LogEntryException;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class DiskLogFile {
    protected File file;
    protected FileChannel channel;
    protected FileInputStream fis;
    protected Checksum csumAlgo;
    protected ByteBuffer myInt;
    protected LogEntry next;

    public DiskLogFile(String baseDir, LSN logLSN) throws IOException, LogEntryException {
        this(baseDir + DiskLogger.createLogFileName(logLSN.getViewId(), logLSN.getSequenceNo()));
    }

    public DiskLogFile(String filename) throws IOException, LogEntryException {
        this.file = new File(filename);
        this.fis = new FileInputStream(this.file);
        this.channel = this.fis.getChannel();
        this.myInt = ByteBuffer.allocate(4);
        this.csumAlgo = new CRC32();
        this.next = this.getNext();
    }

    public void close() throws IOException {
        LogEntry tmp = this.next;
        this.next = null;
        if (tmp != null) {
            tmp.free();
        }
        this.channel.close();
        this.fis.close();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public LogEntry next() throws LogEntryException {
        LogEntry tmp = this.next;
        this.next = this.getNext();
        return tmp;
    }

    /*
     * Loose catch block
     */
    protected LogEntry getNext() throws LogEntryException {
        LogEntry logEntry;
        block16: {
            ReusableBuffer item;
            long offset;
            block14: {
                LogEntry logEntry2;
                block15: {
                    block12: {
                        LogEntry logEntry3;
                        block13: {
                            offset = -1L;
                            item = null;
                            if (this.channel.position() != this.channel.size()) break block12;
                            logEntry3 = null;
                            if (item == null) break block13;
                            BufferPool.free(item);
                        }
                        return logEntry3;
                    }
                    int numRead = this.channel.read(this.myInt);
                    if (numRead >= 4) break block14;
                    logEntry2 = null;
                    if (item == null) break block15;
                    BufferPool.free(item);
                }
                return logEntry2;
            }
            try {
                this.myInt.flip();
                int entrySize = this.myInt.getInt();
                this.myInt.flip();
                offset = this.channel.position() - 4L;
                this.channel.position(offset);
                if (entrySize < 0) {
                    throw new LogEntryException("log entry with negative size detected: " + entrySize);
                }
                item = BufferPool.allocate((int)entrySize);
                this.channel.read(item.getBuffer());
                item.flip();
                LogEntry e = LogEntry.deserialize(item, this.csumAlgo);
                this.csumAlgo.reset();
                logEntry = e;
                if (item == null) break block16;
            }
            catch (LogEntryException ex) {
                LogEntry logEntry4;
                block17: {
                    Logging.logMessage((int)3, (Object)this, (String)"***** INVALID LOG ENTRY *****", (Object[])new Object[0]);
                    Logging.logMessage((int)3, (Object)this, (String)"the log contains an invalid log entry at offset %d, file will be truncated at offset %d", (Object[])new Object[]{offset, offset});
                    Logging.logMessage((int)3, (Object)this, (String)ex.getMessage(), (Object[])new Object[0]);
                    try {
                        this.channel.close();
                        FileOutputStream fout = new FileOutputStream(this.file, true);
                        fout.getChannel().truncate(offset);
                        fout.close();
                        this.fis = new FileInputStream(this.file);
                        this.channel = this.fis.getChannel();
                        this.channel.position(offset);
                    }
                    catch (IOException exc) {
                        throw new LogEntryException("Cannot truncate log file: " + ex);
                    }
                    logEntry4 = null;
                    if (item == null) break block17;
                    BufferPool.free((ReusableBuffer)item);
                }
                return logEntry4;
            }
            catch (IOException ex2) {
                Logging.logMessage((int)7, (Object)this, (String)ex2.getMessage(), (Object[])new Object[0]);
                throw new LogEntryException("Cannot read log entry: " + ex2);
                {
                    catch (Throwable throwable) {
                        if (item != null) {
                            BufferPool.free(item);
                        }
                        throw throwable;
                    }
                }
            }
            BufferPool.free((ReusableBuffer)item);
        }
        return logEntry;
    }
}

