/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.log;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xtreemfs.babudb.log.DiskLogFile;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.log.LogEntryException;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSN;

public class DiskLogIterator
implements Iterator<LogEntry> {
    private String dbLogDir;
    private LSN from;
    private Iterator<LSN> logList;
    private LSN currentLog;
    private DiskLogFile currentFile;
    private LogEntry nextEntry;

    public DiskLogIterator(File[] logFiles, LSN from) throws LogEntryException, IOException {
        this.from = from;
        if (logFiles != null && logFiles.length > 0) {
            int i;
            this.dbLogDir = logFiles[0].getParent() + "/";
            TreeSet<LSN> orderedLogList = new TreeSet<LSN>();
            Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.dbl");
            for (File logFile : logFiles) {
                Matcher m = p.matcher(logFile.getName());
                m.matches();
                String tmp = m.group(1);
                int viewId = Integer.valueOf(tmp);
                tmp = m.group(2);
                int seqNo = Integer.valueOf(tmp);
                orderedLogList.add(new LSN(viewId, seqNo));
            }
            LSN[] copy = orderedLogList.toArray(new LSN[orderedLogList.size()]);
            if (from != null) {
                for (i = 0; i < copy.length - 1 && copy[i + 1].compareTo(from) <= 0; ++i) {
                    orderedLogList.remove(copy[i]);
                }
            }
            LSN last = copy[i];
            if (from != null && !LSMDatabase.NO_DB_LSN.equals(from) && last.getViewId() == from.getViewId() && last.getSequenceNo() > from.getSequenceNo()) {
                throw new LogEntryException("missing log entries: database ends at LSN " + from.toString() + ", first log entry LSN is " + last.toString());
            }
            this.logList = orderedLogList.iterator();
            this.findFirstEntry();
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public LogEntry next() {
        try {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            LogEntry tmp = this.nextEntry;
            this.nextEntry = this.findNextEntry();
            return tmp;
        }
        catch (LogEntryException exc) {
            throw new RuntimeException(exc);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void destroy() throws IOException {
        LogEntry tmp = this.nextEntry;
        this.nextEntry = null;
        if (tmp != null) {
            tmp.free();
        }
        if (this.currentFile != null) {
            this.currentFile.close();
        }
    }

    protected void findFirstEntry() throws IOException, LogEntryException {
        if (this.logList == null || !this.logList.hasNext()) {
            return;
        }
        do {
            this.currentLog = this.logList.next();
            if (this.currentFile != null) {
                this.currentFile.close();
            }
            this.currentFile = new DiskLogFile(this.dbLogDir, this.currentLog);
        } while (!this.currentFile.hasNext() && this.logList.hasNext());
        while (this.currentFile.hasNext()) {
            LogEntry le = this.currentFile.next();
            if (this.from == null || le.getLSN().compareTo(this.from) >= 0) {
                this.nextEntry = le;
                break;
            }
            le.free();
        }
    }

    protected LogEntry findNextEntry() throws IOException, LogEntryException {
        if (this.logList == null) {
            return null;
        }
        if (this.currentFile.hasNext()) {
            return this.currentFile.next();
        }
        this.currentFile.close();
        if (!this.logList.hasNext()) {
            return null;
        }
        this.currentLog = this.logList.next();
        this.currentFile = new DiskLogFile(this.dbLogDir, this.currentLog);
        return this.findNextEntry();
    }
}

