/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.log;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.LogEntry;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class DiskLogger
extends LifeCycleThread {
    public static final int MAX_ENTRIES_PER_BLOCK = 250;
    private static final String RUNTIME_STATE_PROCESSEDLOGENTRIES = "diskLogger.processedLogEntryCount";
    private FileChannel channel;
    private RandomAccessFile fos;
    private FileDescriptor fdes;
    private final LinkedList<LogEntry> entries = new LinkedList();
    private volatile boolean quit = true;
    private boolean graceful;
    private final String logfileDir;
    private final AtomicLong nextLogSequenceNo = new AtomicLong();
    private final AtomicInteger currentViewId = new AtomicInteger();
    private volatile String currentLogFileName;
    private final ReentrantLock sync = new ReentrantLock();
    private final SyncMode syncMode;
    private final Integer pseudoSyncWait;
    private final CRC32 csumAlgo = new CRC32();
    private final int maxQ;
    private AtomicInteger _processedLogEntries = new AtomicInteger();

    public DiskLogger(String logfileDir, LSN initLSN, SyncMode syncMode, int pseudoSyncWait, int maxQ) throws IOException {
        super("DiskLogger");
        if (logfileDir == null) {
            throw new RuntimeException("expected a non-null log file directory name!");
        }
        this.logfileDir = logfileDir.endsWith("/") ? logfileDir : logfileDir + "/";
        if (pseudoSyncWait > 0 && syncMode == SyncMode.ASYNC) {
            Logging.logMessage((int)4, (Object)((Object)this), (String)"When pseudoSyncWait is enabled (> 0) make sure that SyncMode is not ASYNC", (Object[])new Object[0]);
        }
        this.pseudoSyncWait = pseudoSyncWait;
        this.syncMode = syncMode;
        this.maxQ = maxQ;
        this.loadLogFile(initLSN);
    }

    public void dropLogFile() throws IOException {
        File f;
        this.channel.close();
        this.fos.close();
        if (this.currentLogFileName != null && (f = new File(this.currentLogFileName)).length() == 0L) {
            boolean suc = f.delete();
            assert (suc) : "An empty database log file could not have been deleted properly.";
        }
        this.channel = null;
        this.fos = null;
        this.currentLogFileName = null;
    }

    public void loadLogFile(LSN initLSN) throws IOException {
        if (initLSN != null) {
            this.currentViewId.set(initLSN.getViewId());
            assert (initLSN.getSequenceNo() > 0L);
            this.nextLogSequenceNo.set(initLSN.getSequenceNo());
        }
        this.loadLogFile();
    }

    public long getLogFileSize() {
        return new File(this.currentLogFileName).length();
    }

    public synchronized void append(LogEntry entry) throws InterruptedException, IllegalStateException {
        assert (entry != null);
        if (!this.quit && this.maxQ > 0 && this.entries.size() >= this.maxQ) {
            ((Object)((Object)this)).wait();
        }
        if (!this.quit) {
            assert (this.maxQ == 0 || this.entries.size() < this.maxQ);
        } else {
            throw new InterruptedException("Appending the LogEntry to the DiskLogger's queue was interrupted, due DiskLogger shutdown.");
        }
        this.entries.add(entry);
        ((Object)((Object)this)).notifyAll();
    }

    public void lock() throws InterruptedException {
        this.sync.lockInterruptibly();
    }

    public boolean hasLock() {
        return this.sync.isHeldByCurrentThread();
    }

    public void unlock() {
        this.sync.unlock();
    }

    public LSN switchLogFile(boolean incrementViewId) throws IOException {
        if (!this.hasLock()) {
            throw new IllegalStateException("the lock is held by another thread or the logger is not locked.");
        }
        LSN lastSyncedLSN = null;
        if (incrementViewId) {
            int view = this.currentViewId.getAndIncrement();
            long seq = this.nextLogSequenceNo.getAndSet(1L) - 1L;
            assert (seq != 0L) : "Checkpoint after checkpoint is not allowed!";
            lastSyncedLSN = new LSN(view, seq);
        } else {
            lastSyncedLSN = new LSN(this.currentViewId.get(), this.nextLogSequenceNo.get() - 1L);
        }
        this.dropLogFile();
        this.loadLogFile();
        return lastSyncedLSN;
    }

    public synchronized void start() {
        assert (this.quit);
        this.quit = false;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<LogEntry> tmpE = new ArrayList<LogEntry>(250);
        Logging.logMessage((int)7, (Object)((Object)this), (String)"operational", (Object[])new Object[0]);
        this.notifyStarted();
        while (!this.quit) {
            try {
                DiskLogger diskLogger = this;
                synchronized (diskLogger) {
                    block25: {
                        if (!this.quit && this.entries.isEmpty()) {
                            ((Object)((Object)this)).wait();
                        }
                        if (!this.quit) break block25;
                        break;
                    }
                    LogEntry tmp = null;
                    while (tmpE.size() < 249 && (tmp = this.entries.poll()) != null) {
                        tmpE.add(tmp);
                    }
                    ((Object)((Object)this)).notifyAll();
                    this.lock();
                }
                this.processLogEntries(tmpE);
            }
            catch (IOException ex) {
                Logging.logError((int)3, (Object)((Object)this), (Throwable)ex);
                for (LogEntry le : tmpE) {
                    le.free();
                    le.getListener().failed(ex);
                }
                tmpE.clear();
            }
            catch (InterruptedException ex) {
                if (this.quit) continue;
                try {
                    this.cleanUp();
                }
                catch (IOException e) {
                    Logging.logError((int)3, (Object)((Object)this), (Throwable)e);
                }
                this.notifyCrashed(ex);
                return;
            }
            finally {
                if (!this.hasLock()) continue;
                this.unlock();
            }
        }
        try {
            if (this.graceful) {
                try {
                    this.lock();
                    this.processLogEntries(this.entries);
                }
                finally {
                    if (this.hasLock()) {
                        this.unlock();
                    }
                }
            }
            this.cleanUp();
            Logging.logMessage((int)7, (Object)((Object)this), (String)"disk logger shut down successfully", (Object[])new Object[0]);
            this.notifyStopped();
        }
        catch (Exception e) {
            this.notifyCrashed(e);
        }
    }

    public void shutdown() throws InterruptedException {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean graceful) throws InterruptedException {
        this.lock();
        this.graceful = graceful;
        this.quit = true;
        ((Object)((Object)this)).notifyAll();
        if (!graceful && this.pseudoSyncWait > 0) {
            Integer n = this.pseudoSyncWait;
            synchronized (n) {
                this.pseudoSyncWait.notify();
            }
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void destroy() {
        this.stop();
        try {
            try {
                this.fdes.sync();
            }
            finally {
                this.fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public LSN getLatestLSN() {
        return new LSN(this.currentViewId.get(), this.nextLogSequenceNo.get() - 1L);
    }

    public Object getRuntimeState(String property) {
        if (RUNTIME_STATE_PROCESSEDLOGENTRIES.equals(property)) {
            return this._processedLogEntries.get();
        }
        return null;
    }

    public Map<String, Object> getRuntimeState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RUNTIME_STATE_PROCESSEDLOGENTRIES, this._processedLogEntries.get());
        return map;
    }

    private String createLogFileName() {
        return this.logfileDir + DiskLogger.createLogFileName(this.currentViewId.get(), this.nextLogSequenceNo.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() throws IOException {
        try {
            this.fdes.sync();
        }
        finally {
            try {
                this.fos.close();
            }
            finally {
                DiskLogger diskLogger = this;
                synchronized (diskLogger) {
                    assert (this.graceful || this.entries.size() == 0);
                    for (LogEntry le : this.entries) {
                        le.free();
                        le.getListener().failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "DiskLogger was shut down, before the entry could be written to the log-file"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processLogEntries(List<LogEntry> entries) throws IOException, InterruptedException {
        assert (this.hasLock());
        for (LogEntry le : entries) {
            assert (le != null) : "Entry must not be null";
            int viewID = this.currentViewId.get();
            long seqNo = this.nextLogSequenceNo.getAndIncrement();
            if (le.getLSN() != null && (le.getLSN().getSequenceNo() != seqNo || le.getLSN().getViewId() != viewID)) {
                throw new IOException("LogEntry (" + le.getPayloadType() + ") had unexpected LSN: " + le.getLSN() + "\n" + viewID + ":" + seqNo + " was expected instead.");
            }
            le.assignId(viewID, seqNo);
            ReusableBuffer buffer = null;
            try {
                buffer = le.serialize(this.csumAlgo);
                Logging.logMessage((int)7, (Object)((Object)this), (String)"Writing entry LSN(%d:%d) with %d bytes payload [%s] to log. [serialized %d bytes]", (Object[])new Object[]{viewID, seqNo, le.getPayload().remaining(), new String(le.getPayload().array()), buffer.remaining()});
                this.channel.write(buffer.getBuffer());
            }
            finally {
                this.csumAlgo.reset();
                if (buffer != null) {
                    BufferPool.free((ReusableBuffer)buffer);
                }
            }
            this._processedLogEntries.incrementAndGet();
        }
        if (this.syncMode == SyncMode.FSYNC) {
            this.channel.force(true);
        } else if (this.syncMode == SyncMode.FDATASYNC) {
            this.channel.force(false);
        }
        for (LogEntry le : entries) {
            le.free();
            le.getListener().synced(le.getLSN());
        }
        entries.clear();
        if (this.pseudoSyncWait > 0) {
            Integer n = this.pseudoSyncWait;
            synchronized (n) {
                this.pseudoSyncWait.wait(this.pseudoSyncWait.intValue());
            }
        }
    }

    static final String createLogFileName(int viewId, long sequenceNo) {
        return viewId + "." + sequenceNo + ".dbl";
    }

    static final LSN disassembleLogFileName(String name) {
        String[] parts = name.split(".");
        assert (parts.length == 3);
        return new LSN(Integer.parseInt(parts[0]), Long.parseLong(parts[1]));
    }

    private void loadLogFile() throws IOException {
        assert (this.channel == null && this.fos == null);
        this.currentLogFileName = this.createLogFileName();
        File lf = new File(this.currentLogFileName);
        if (!lf.getParentFile().exists() && !lf.getParentFile().mkdirs()) {
            throw new IOException("could not create parent directory for database log file");
        }
        String openMode = "";
        switch (this.syncMode) {
            case ASYNC: 
            case FSYNC: 
            case FDATASYNC: {
                openMode = "rw";
                break;
            }
            case SYNC_WRITE: {
                openMode = "rwd";
                break;
            }
            case SYNC_WRITE_METADATA: {
                openMode = "rws";
            }
        }
        this.fos = new RandomAccessFile(lf, openMode);
        this.fos.setLength(0L);
        this.channel = this.fos.getChannel();
        this.fdes = this.fos.getFD();
    }

    public static enum SyncMode {
        ASYNC,
        FSYNC,
        FDATASYNC,
        SYNC_WRITE,
        SYNC_WRITE_METADATA;

    }
}

