/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.log;

import java.util.zip.Checksum;
import org.xtreemfs.babudb.log.LogEntryException;
import org.xtreemfs.babudb.log.SyncListener;
import org.xtreemfs.babudb.lsmdb.LSMDBRequest;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;

public class LogEntry {
    protected static final int headerLength = 25;
    public static final boolean USE_CHECKSUMS = true;
    public static final byte PAYLOAD_TYPE_INSERT = 0;
    public static final byte PAYLOAD_TYPE_SNAP = 1;
    public static final byte PAYLOAD_TYPE_CREATE = 2;
    public static final byte PAYLOAD_TYPE_COPY = 3;
    public static final byte PAYLOAD_TYPE_DELETE = 4;
    public static final byte PAYLOAD_TYPE_SNAP_DELETE = 5;
    public static final byte PAYLOAD_TYPE_TRANSACTION = 6;
    protected int viewId = -1;
    protected long logSequenceNo = -1L;
    protected int checksum;
    protected ReusableBuffer payload;
    protected SyncListener listener;
    private LSMDBRequest<?> attachment;
    protected byte payloadType;

    private LogEntry() {
    }

    public LogEntry(ReusableBuffer payload, SyncListener l, byte payloadType) {
        assert (payload != null);
        this.payload = payload;
        this.listener = l;
        this.payloadType = payloadType;
    }

    public void assignId(int viewId, long logSequenceNo) {
        this.viewId = viewId;
        this.logSequenceNo = logSequenceNo;
    }

    public ReusableBuffer serialize(Checksum csumAlgo) {
        assert (this.viewId > 0);
        assert (this.logSequenceNo > 0L);
        int bufSize = 25 + this.payload.remaining();
        ReusableBuffer buf = BufferPool.allocate((int)bufSize);
        buf.putInt(bufSize);
        buf.putInt(this.checksum);
        buf.putInt(this.viewId);
        buf.putLong(this.logSequenceNo);
        buf.put(this.payloadType);
        buf.put(this.payload);
        this.payload.flip();
        buf.putInt(bufSize);
        buf.flip();
        buf.position(4);
        buf.putInt(0);
        buf.position(0);
        csumAlgo.update(buf.array(), 0, bufSize);
        int cPos = buf.position();
        buf.position(4);
        buf.putInt((int)csumAlgo.getValue());
        buf.position(cPos);
        return buf;
    }

    public void setListener(SyncListener listener) {
        this.listener = listener;
    }

    public SyncListener getListener() {
        return this.listener;
    }

    public ReusableBuffer getPayload() {
        return this.payload;
    }

    public int getViewId() {
        return this.viewId;
    }

    public long getLogSequenceNo() {
        return this.logSequenceNo;
    }

    public LSN getLSN() {
        if (this.viewId == -1 && this.logSequenceNo == -1L) {
            return null;
        }
        return new LSN(this.viewId, this.logSequenceNo);
    }

    public static void checkIntegrity(ReusableBuffer data) throws LogEntryException {
        int cPos = data.position();
        if (data.remaining() < 4) {
            throw new LogEntryException("Empty data. Cannot read log entry.");
        }
        int length1 = data.getInt();
        if (length1 - 4 > data.remaining()) {
            data.position(cPos);
            Logging.logMessage((int)7, null, (String)"not long enough", (Object[])new Object[0]);
            throw new LogEntryException("The log entry is incomplete. The length indicated in the header exceeds the available data.");
        }
        data.position(cPos + length1 - 4);
        int length2 = data.getInt();
        data.position(cPos);
        if (length1 != length2) {
            throw new LogEntryException("Invalid Frame. The length entries do not match; length1=" + length1 + ", length2=" + length2);
        }
    }

    public static LogEntry deserialize(ReusableBuffer data, Checksum csumAlgo) throws LogEntryException {
        LogEntry.checkIntegrity(data);
        int startPos = data.position();
        int bufSize = data.getInt();
        LogEntry e = new LogEntry();
        e.checksum = data.getInt();
        e.viewId = data.getInt();
        e.logSequenceNo = data.getLong();
        e.payloadType = data.get();
        int payloadSize = bufSize - 25;
        int payloadPosition = data.position();
        ReusableBuffer payload = data.createViewBuffer();
        payload.range(payloadPosition, payloadSize);
        e.payload = payload;
        data.position(startPos + 4);
        data.putInt(0);
        data.position(startPos);
        csumAlgo.update(data.array(), startPos, bufSize);
        int csum = (int)csumAlgo.getValue();
        data.position(startPos + 4);
        data.putInt(e.checksum);
        if (csum != e.checksum) {
            throw new LogEntryException("Invalid Checksum. Checksum in log entry and calculated checksum do not match.");
        }
        data.position(startPos);
        return e;
    }

    public void free() {
        BufferPool.free((ReusableBuffer)this.payload);
        this.payload = null;
    }

    public LSMDBRequest<?> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(LSMDBRequest<?> attachment) {
        this.attachment = attachment;
    }

    public byte getPayloadType() {
        return this.payloadType;
    }

    public LogEntry clone() {
        LogEntry result = new LogEntry(this.payload.createViewBuffer(), this.listener, this.payloadType);
        result.assignId(this.viewId, this.logSequenceNo);
        result.attachment = this.attachment;
        result.checksum = this.checksum;
        return result;
    }

    public String toString() {
        return "LSN(" + this.viewId + ":" + this.logSequenceNo + ") with " + this.payload.remaining() + " bytes of payload.";
    }
}

