/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.dev.transaction.OperationInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.api.transaction.Operation;
import org.xtreemfs.babudb.lsmdb.InsertRecordGroup;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class BabuDBTransaction
extends TransactionInternal {
    private static final long serialVersionUID = 3772453774367730087L;
    private BabuDBException error = null;

    @Override
    public TransactionInternal createSnapshot(String databaseName, SnapshotConfig config) {
        return this.addOperation(new BabuDBOperation(1, databaseName, new Object[]{-1, config}));
    }

    @Override
    public TransactionInternal deleteSnapshot(String databaseName, String snapshotName) {
        return this.addOperation(new BabuDBOperation(5, databaseName, new Object[]{snapshotName}));
    }

    @Override
    public TransactionInternal copyDatabase(String sourceName, String destinationName) {
        return this.addOperation(new BabuDBOperation(3, sourceName, new Object[]{destinationName}));
    }

    @Override
    public TransactionInternal createDatabase(String databaseName, int numIndices) {
        return this.createDatabase(databaseName, numIndices, null);
    }

    @Override
    public TransactionInternal createDatabase(String databaseName, int numIndices, ByteRangeComparator[] comparators) {
        return this.addOperation(new BabuDBOperation(2, databaseName, new Object[]{numIndices, comparators}));
    }

    @Override
    public TransactionInternal deleteDatabase(String databaseName) {
        return this.addOperation(new BabuDBOperation(4, databaseName, null));
    }

    @Override
    public TransactionInternal deleteRecord(String databaseName, int indexId, byte[] key) {
        InsertRecordGroup irg = new InsertRecordGroup(-1);
        irg.addInsert(indexId, key, null);
        return this.insertRecordGroup(databaseName, irg);
    }

    @Override
    public TransactionInternal insertRecord(String databaseName, int indexId, byte[] key, byte[] value) {
        InsertRecordGroup irg = new InsertRecordGroup(-1);
        irg.addInsert(indexId, key, value);
        return this.insertRecordGroup(databaseName, irg);
    }

    @Override
    public TransactionInternal insertRecordGroup(String databaseName, InsertRecordGroup irg) {
        return this.insertRecordGroup(databaseName, irg, null);
    }

    @Override
    public TransactionInternal insertRecordGroup(String databaseName, InsertRecordGroup irg, LSMDatabase db) {
        return this.addOperation(new BabuDBOperation(0, databaseName, new Object[]{irg, db}));
    }

    @Override
    public List<Operation> getOperations() {
        return new LinkedList<Operation>(this);
    }

    @Override
    public TransactionInternal addOperation(OperationInternal op) {
        this.add(op);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName() + "\n");
        sb.append("operations:\n");
        for (Operation op : this) {
            sb.append(op + "\n");
        }
        return sb.toString();
    }

    @Override
    public int getSize() throws IOException {
        TreeSet<String> dbNames = new TreeSet<String>();
        for (Operation op : this) {
            dbNames.add(op.getDatabaseName());
        }
        int size = 8;
        for (String dbName : dbNames) {
            size += 4 + dbName.getBytes().length;
        }
        for (OperationInternal op : this) {
            size += op.getSize();
        }
        return size;
    }

    @Override
    public ReusableBuffer serialize(ReusableBuffer buffer) throws IOException {
        TreeSet<String> dbNames = new TreeSet<String>();
        for (Operation op : this) {
            dbNames.add(op.getDatabaseName());
        }
        buffer.putInt(dbNames.size());
        for (String dbName : dbNames) {
            buffer.putInt(dbName.length());
            buffer.put(dbName.getBytes());
        }
        buffer.putInt(this.size());
        for (Operation op : this) {
            ((OperationInternal)op).serialize(dbNames, buffer);
        }
        return buffer;
    }

    @Override
    public void cutOfAt(int position, BabuDBException reason) {
        assert (reason != null && this.error == null);
        this.error = reason;
        while (this.size() > position) {
            this.removeLast();
        }
    }

    @Override
    public BabuDBException getIrregularities() {
        return this.error;
    }

    public static class BabuDBOperation
    extends OperationInternal {
        private byte type;
        private Object[] params;
        private String dbName;

        public BabuDBOperation(byte type, String dbName, Object[] params) {
            this.type = type;
            this.params = params;
            this.dbName = dbName;
        }

        @Override
        public Object[] getParams() {
            return this.params;
        }

        @Override
        public void updateParams(Object[] params) {
            this.params = params;
        }

        @Override
        public byte getType() {
            return this.type;
        }

        @Override
        public String getDatabaseName() {
            return this.dbName;
        }

        @Override
        public void updateDatabaseName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public int getSize() throws IOException {
            int size = 9;
            if (this.params != null) {
                for (Object obj : this.params) {
                    if (obj == null || obj instanceof LSMDatabase || obj instanceof BabuDBRequestResultImpl) continue;
                    if (obj instanceof String) {
                        size += 5 + ((String)obj).getBytes().length;
                        continue;
                    }
                    if (obj instanceof Integer) {
                        size += 5;
                        continue;
                    }
                    if (obj instanceof Long) {
                        size += 9;
                        continue;
                    }
                    if (obj instanceof Short) {
                        size += 3;
                        continue;
                    }
                    if (obj instanceof Byte) {
                        size += 2;
                        continue;
                    }
                    if (obj instanceof byte[]) {
                        size += 5 + ((byte[])obj).length;
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        size += 2;
                        continue;
                    }
                    if (obj instanceof InsertRecordGroup) {
                        size += 5 + ((InsertRecordGroup)obj).getSize();
                        continue;
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bout);
                    out.writeObject(obj);
                    size += 5 + bout.toByteArray().length;
                    out.close();
                }
            }
            return size;
        }

        @Override
        public ReusableBuffer serialize(SortedSet<String> dbNameSet, ReusableBuffer buffer) throws IOException {
            int size = 0;
            int start = 0;
            assert ((size = this.getSize()) > -1);
            assert ((start = buffer.position()) > -1);
            buffer.put(this.type);
            int dbNameIndex = -1;
            Iterator it = dbNameSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                String curr = (String)it.next();
                if (curr.equals(this.dbName)) {
                    dbNameIndex = i;
                }
                ++i;
            }
            assert (dbNameIndex >= 0);
            buffer.putInt(dbNameIndex);
            int count = 0;
            if (this.params != null) {
                for (Object obj : this.params) {
                    if (obj == null || obj instanceof LSMDatabase || obj instanceof BabuDBRequestResultImpl) continue;
                    ++count;
                }
            }
            buffer.putInt(count);
            if (this.params != null) {
                for (Object obj : this.params) {
                    if (obj == null || obj instanceof LSMDatabase || obj instanceof BabuDBRequestResultImpl) continue;
                    BabuDBOperation.serializeParam(buffer, obj);
                }
            }
            assert (buffer.position() - start == size) : "Operation " + this.type + " was not serialized successfully!";
            return buffer;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("opcode: " + this.type + "\n");
            sb.append("params: " + (this.params == null ? null : Arrays.toString(this.params)));
            return sb.toString();
        }

        private static void serializeParam(ReusableBuffer buffer, Object obj) throws IOException {
            if (obj instanceof String) {
                String string = (String)obj;
                buffer.put((byte)6);
                buffer.putInt(string.getBytes().length);
                buffer.put(string.getBytes());
            } else if (obj instanceof byte[]) {
                byte[] bytes = (byte[])obj;
                buffer.put((byte)5);
                buffer.putInt(bytes.length);
                buffer.put(bytes);
            } else if (obj instanceof Integer) {
                Integer integer = (Integer)obj;
                buffer.put((byte)0);
                buffer.putInt(integer.intValue());
            } else if (obj instanceof Long) {
                Long longInt = (Long)obj;
                buffer.put((byte)2);
                buffer.putLong(longInt.longValue());
            } else if (obj instanceof Short) {
                Short shortInt = (Short)obj;
                buffer.put((byte)1);
                buffer.putShort(shortInt.shortValue());
            } else if (obj instanceof Boolean) {
                Boolean bool = (Boolean)obj;
                buffer.put((byte)3);
                buffer.putBoolean(bool.booleanValue());
            } else if (obj instanceof Byte) {
                Byte byteObj = (Byte)obj;
                buffer.put((byte)4);
                buffer.put(byteObj.byteValue());
            } else if (obj instanceof InsertRecordGroup) {
                InsertRecordGroup irg = (InsertRecordGroup)obj;
                int size = irg.getSize();
                ReusableBuffer buf = BufferPool.allocate((int)size);
                irg.serialize(buf);
                buf.flip();
                buffer.put((byte)8);
                buffer.putInt(size);
                buffer.put(buf);
                BufferPool.free((ReusableBuffer)buf);
            } else {
                buffer.put((byte)7);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(obj);
                out.close();
                byte[] bytes = bout.toByteArray();
                buffer.putInt(bytes.length);
                buffer.put(bytes);
                bout.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Object deserializeParam(ReusableBuffer buffer) throws IOException {
            byte fieldType = buffer.get();
            switch (fieldType) {
                case 0: {
                    return buffer.getInt();
                }
                case 1: {
                    return buffer.getShort();
                }
                case 2: {
                    return buffer.getLong();
                }
                case 3: {
                    return buffer.getBoolean();
                }
                case 4: {
                    return buffer.get();
                }
                case 5: {
                    int length = buffer.getInt();
                    byte[] bytes = new byte[length];
                    buffer.get(bytes);
                    return bytes;
                }
                case 6: {
                    byte[] bytes = new byte[buffer.getInt()];
                    buffer.get(bytes);
                    return new String(bytes);
                }
                case 7: {
                    Object obj;
                    int length = buffer.getInt();
                    byte[] bytes = new byte[length];
                    buffer.get(bytes);
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                    try {
                        obj = in.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e);
                    }
                    in.close();
                    return obj;
                }
                case 8: {
                    InsertRecordGroup insertRecordGroup;
                    int length = buffer.getInt();
                    ReusableBuffer view = null;
                    try {
                        int bufferPos = buffer.position();
                        int pos = bufferPos + length;
                        view = buffer.createViewBuffer();
                        view.position(bufferPos);
                        view.limit(pos);
                        buffer.position(pos);
                        insertRecordGroup = InsertRecordGroup.deserialize(view);
                        if (view == null) return insertRecordGroup;
                    }
                    catch (Throwable throwable) {
                        if (view == null) throw throwable;
                        BufferPool.free(view);
                        throw throwable;
                    }
                    BufferPool.free((ReusableBuffer)view);
                    return insertRecordGroup;
                }
            }
            throw new IOException("invalid field type:" + fieldType);
        }
    }
}

