/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.CheckpointerInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.dev.SnapshotManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.log.DiskLogger;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;

public class CheckpointerImpl
extends CheckpointerInternal {
    private static final String RUNTIME_STATE_CPCOUNT = "checkpointer.cpCount";
    private static final String RUNTIME_STATE_LASTCP = "checkpointer.lastCpTimestampMillis";
    private static final String RUNTIME_STATE_LASTCPDURATION = "checkpointer.lastCpDurationMillis";
    private volatile boolean quit;
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private final Object suspensionLock = new Object();
    private DiskLogger logger;
    private long checkInterval;
    private long maxLogLength;
    private final BabuDBInternal dbs;
    private final List<MaterializationRequest> requests = new LinkedList<MaterializationRequest>();
    private boolean forceCheckpoint;
    private AtomicBoolean checkpointComplete = new AtomicBoolean(true);
    private boolean incrementViewId = false;
    private volatile LSN lastWrittenLSN;
    private AtomicInteger _checkpointCount = new AtomicInteger();
    private AtomicLong _lastCheckpoint = new AtomicLong();
    private AtomicLong _lastCheckpointDuration = new AtomicLong();

    public CheckpointerImpl(BabuDBInternal master) {
        this.setLifeCycleListener(master);
        this.dbs = master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DiskLogger logger, int checkInterval, long maxLogLength) throws BabuDBException {
        this.logger = logger;
        this.checkInterval = 1000L * (long)checkInterval;
        this.maxLogLength = maxLogLength;
        if (!this.suspended.compareAndSet(true, false) && !this.quit) {
            this.start();
            try {
                this.waitForStartup();
            }
            catch (Exception e) {
                throw new BabuDBException(BabuDBException.ErrorCode.INTERNAL_ERROR, e.getMessage(), e);
            }
        }
        Object object = this.suspensionLock;
        synchronized (object) {
            this.suspensionLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendCheckpointing() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.suspended;
        synchronized (atomicBoolean) {
            if (!this.suspended.compareAndSet(false, true)) {
                CheckpointerImpl checkpointerImpl = this;
                synchronized (checkpointerImpl) {
                    this.notify();
                }
                this.suspended.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LSN checkpoint(boolean incViewId) throws BabuDBException {
        Object object = this.checkpointComplete;
        synchronized (object) {
            this.checkpointComplete.set(false);
        }
        object = this;
        synchronized (object) {
            this.incrementViewId = incViewId;
            this.forceCheckpoint = true;
            this.notify();
        }
        try {
            this.waitForCheckpoint();
            return this.lastWrittenLSN;
        }
        catch (InterruptedException e) {
            throw new BabuDBException(BabuDBException.ErrorCode.INTERNAL_ERROR, "interrupted", e);
        }
    }

    @Override
    public void checkpoint() throws BabuDBException, InterruptedException {
        this.checkpoint(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void materializeSnapshots() throws BabuDBException {
        while (true) {
            MaterializationRequest rq = null;
            List<MaterializationRequest> list = this.requests;
            synchronized (list) {
                if (this.requests.size() > 0) {
                    rq = this.requests.remove(0);
                }
            }
            if (rq == null) break;
            if (Logging.isDebug()) {
                Logging.logMessage((int)7, (Object)this, (String)("snapshot materialization request found for database '" + rq.dbName + "', snapshot: '" + rq.snap.getName() + "'"), (Object[])new Object[0]);
            }
            SnapshotManagerInternal snapMan = this.dbs.getSnapshotManager();
            this.dbs.getDatabaseManager().getDatabase(rq.dbName).proceedWriteSnapshot(rq.snapIDs, snapMan.getSnapshotDir(rq.dbName, rq.snap.getName()), rq.snap);
            snapMan.snapshotComplete(rq.dbName, rq.snap);
            Logging.logMessage((int)7, (Object)this, (String)"snapshot materialization complete", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCheckpoint() throws BabuDBException, InterruptedException {
        Logging.logMessage((int)6, (Object)this, (String)"initiating database checkpoint...", (Object[])new Object[0]);
        Collection<DatabaseInternal> databases = this.dbs.getDatabaseManager().getDatabaseList();
        try {
            int[][] snapIds = new int[databases.size()][];
            int i = 0;
            try {
                this.logger.lock();
                for (DatabaseInternal db : databases) {
                    snapIds[i++] = db.proceedCreateSnapshot();
                }
                this.lastWrittenLSN = this.logger.switchLogFile(this.incrementViewId);
                this.incrementViewId = false;
            }
            finally {
                if (this.logger.hasLock()) {
                    this.logger.unlock();
                }
            }
            i = 0;
            for (DatabaseInternal db : databases) {
                db.proceedWriteSnapshot(this.lastWrittenLSN.getViewId(), this.lastWrittenLSN.getSequenceNo(), snapIds[i++]);
                db.proceedCleanupSnapshot(this.lastWrittenLSN.getViewId(), this.lastWrittenLSN.getSequenceNo());
            }
            File f = new File(this.dbs.getConfig().getDbLogDir());
            String[] logs = f.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".dbl");
                }
            });
            if (logs != null) {
                Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.dbl");
                for (String log : logs) {
                    Matcher m = p.matcher(log);
                    m.matches();
                    String tmp = m.group(1);
                    int viewId = Integer.valueOf(tmp);
                    tmp = m.group(2);
                    int seqNo = Integer.valueOf(tmp);
                    LSN logLSN = new LSN(viewId, seqNo);
                    if (logLSN.compareTo(this.lastWrittenLSN) > 0) continue;
                    Logging.logMessage((int)7, (Object)this, (String)("deleting old db log file: " + log), (Object[])new Object[0]);
                    f = new File(this.dbs.getConfig().getDbLogDir() + log);
                    if (f.delete()) continue;
                    Logging.logMessage((int)4, (Object)this, (String)"could not delete log file: %s", (Object[])new Object[]{f.getAbsolutePath()});
                }
            }
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot create checkpoint", ex);
        }
        Logging.logMessage((int)6, (Object)this, (String)"checkpoint complete", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSnapshotMaterializationRequest(String dbName, int[] snapIds, SnapshotConfig snap) {
        List<MaterializationRequest> list = this.requests;
        synchronized (list) {
            this.requests.add(new MaterializationRequest(dbName, snapIds, snap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSnapshotMaterializationRequest(String dbName, String snapshotName) {
        List<MaterializationRequest> list = this.requests;
        synchronized (list) {
            for (MaterializationRequest rq : this.requests) {
                if (!snapshotName.equals(rq.snap.getName())) continue;
                this.requests.remove(rq);
                break;
            }
        }
    }

    public synchronized void shutdown() {
        this.quit = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Logging.logMessage((int)7, (Object)this, (String)"operational", (Object[])new Object[0]);
        boolean manualCheckpoint = false;
        this.notifyStarted();
        while (!this.quit) {
            Object object;
            try {
                Object object2 = this;
                synchronized (object2) {
                    if (!this.forceCheckpoint) {
                        this.wait(this.checkInterval);
                    }
                    manualCheckpoint = this.forceCheckpoint;
                    this.forceCheckpoint = false;
                }
                object2 = this.suspended;
                synchronized (object2) {
                    if (this.suspended.get()) {
                        this.suspended.notify();
                        object = this.suspensionLock;
                        synchronized (object) {
                            this.suspensionLock.wait();
                            continue;
                        }
                    }
                }
                long lfsize = this.logger.getLogFileSize();
                if (!manualCheckpoint && lfsize <= this.maxLogLength) continue;
                if (!manualCheckpoint) {
                    Logging.logMessage((int)6, (Object)this, (String)("database operation log has exceeded threshold size of " + this.maxLogLength + " (" + lfsize + ")"), (Object[])new Object[0]);
                } else {
                    Logging.logMessage((int)6, (Object)this, (String)"triggered manual checkpoint", (Object[])new Object[0]);
                }
                Object object3 = this.dbs.getDatabaseManager().getDBModificationLock();
                synchronized (object3) {
                    CheckpointerImpl checkpointerImpl = this;
                    synchronized (checkpointerImpl) {
                        long start = System.currentTimeMillis();
                        this.materializeSnapshots();
                        this.createCheckpoint();
                        this._checkpointCount.incrementAndGet();
                        this._lastCheckpoint.set(System.currentTimeMillis());
                        this._lastCheckpointDuration.set(System.currentTimeMillis() - start);
                    }
                }
            }
            catch (InterruptedException ex) {
                if (this.quit) break;
                Logging.logMessage((int)7, (Object)this, (String)"CHECKPOINT WAS ABORTED!", (Object[])new Object[0]);
            }
            catch (Throwable ex) {
                if (ex instanceof BabuDBException && ((BabuDBException)ex).getCause() instanceof ClosedByInterruptException) {
                    Logging.logMessage((int)7, (Object)this, (String)"CHECKPOINT WAS ABORTED!", (Object[])new Object[0]);
                    continue;
                }
                Logging.logMessage((int)3, (Object)this, (String)"DATABASE CHECKPOINT CREATION FAILURE!", (Object[])new Object[0]);
                Logging.logMessage((int)3, (Object)this, (String)OutputUtils.stackTraceToString((Throwable)ex), (Object[])new Object[0]);
            }
            finally {
                object = this.checkpointComplete;
                synchronized (object) {
                    this.checkpointComplete.set(true);
                    this.checkpointComplete.notify();
                }
            }
        }
        Logging.logMessage((int)7, (Object)this, (String)"checkpointer shut down successfully", (Object[])new Object[0]);
        this.notifyStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCheckpoint() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.checkpointComplete;
        synchronized (atomicBoolean) {
            while (!this.checkpointComplete.get()) {
                this.checkpointComplete.wait();
            }
        }
    }

    @Override
    public Object getRuntimeState(String property) {
        if (RUNTIME_STATE_CPCOUNT.equals(property)) {
            return this._checkpointCount.get();
        }
        if (RUNTIME_STATE_LASTCP.equals(property)) {
            return this._lastCheckpoint.get();
        }
        if (RUNTIME_STATE_LASTCPDURATION.equals(property)) {
            return this._lastCheckpointDuration.get();
        }
        return null;
    }

    @Override
    public Map<String, Object> getRuntimeState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RUNTIME_STATE_CPCOUNT, this._checkpointCount.get());
        map.put(RUNTIME_STATE_LASTCP, this._lastCheckpoint.get());
        map.put(RUNTIME_STATE_LASTCPDURATION, this._lastCheckpointDuration.get());
        return map;
    }

    private static final class MaterializationRequest {
        String dbName;
        int[] snapIDs;
        SnapshotConfig snap;

        MaterializationRequest(String dbName, int[] snapIDs, SnapshotConfig snap) {
            this.dbName = dbName;
            this.snapIDs = snapIDs;
            this.snap = snap;
        }
    }
}

