/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.Set;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.dev.DatabaseManagerInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.lsmdb.DatabaseImpl;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.foundation.logging.Logging;

public class DBConfig {
    private final BabuDBInternal dbs;
    private final File configFile;
    private boolean conversionRequired;
    private int dbFormatVer;

    public DBConfig(BabuDBInternal dbs) throws BabuDBException {
        this.dbs = dbs;
        this.configFile = new File(dbs.getConfig().getBaseDir() + dbs.getConfig().getDbCfgFile());
        this.load();
    }

    public void reset() throws BabuDBException {
        DatabaseManagerInternal dbman = this.dbs.getDatabaseManager();
        assert (dbman != null) : "The DatabaseManager is not available!";
        ObjectInputStream ois = null;
        try {
            LinkedList<Integer> ids = new LinkedList<Integer>();
            if (this.configFile.exists()) {
                ois = new ObjectInputStream(new FileInputStream(this.configFile));
                int dbFormatVer = ois.readInt();
                if (dbFormatVer != 4) {
                    throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "on-disk format (version " + dbFormatVer + ") is incompatible with this BabuDB release " + "(uses on-disk format version " + 4 + ")");
                }
                int numDB = ois.readInt();
                dbman.setNextDBId(ois.readInt());
                for (int i = 0; i < numDB; ++i) {
                    DatabaseInternal db;
                    Logging.logMessage((int)7, (Object)this, (String)"loading DB...", (Object[])new Object[0]);
                    String dbName = (String)ois.readObject();
                    int dbId = ois.readInt();
                    int numIndex = ois.readInt();
                    ByteRangeComparator[] comps = new ByteRangeComparator[numIndex];
                    for (int idx = 0; idx < numIndex; ++idx) {
                        String className = (String)ois.readObject();
                        ByteRangeComparator comp = dbman.getComparatorInstances().get(className);
                        if (comp == null) {
                            Class<?> clazz = Class.forName(className);
                            comp = (ByteRangeComparator)clazz.newInstance();
                            dbman.getComparatorInstances().put(className, comp);
                        }
                        assert (comp != null);
                        comps[idx] = comp;
                    }
                    ids.add(dbId);
                    try {
                        db = dbman.getDatabase(dbId);
                        db.setLSMDB(new LSMDatabase(dbName, dbId, this.dbs.getConfig().getBaseDir() + dbName + File.separatorChar, numIndex, true, comps, this.dbs.getConfig().getCompression(), this.dbs.getConfig().getMaxNumRecordsPerBlock(), this.dbs.getConfig().getMaxBlockFileSize(), this.dbs.getConfig().getDisableMMap(), this.dbs.getConfig().getMMapLimit()));
                    }
                    catch (BabuDBException e) {
                        db = new DatabaseImpl(this.dbs, new LSMDatabase(dbName, dbId, this.dbs.getConfig().getBaseDir() + dbName + File.separatorChar, numIndex, true, comps, this.dbs.getConfig().getCompression(), this.dbs.getConfig().getMaxNumRecordsPerBlock(), this.dbs.getConfig().getMaxBlockFileSize(), this.dbs.getConfig().getDisableMMap(), this.dbs.getConfig().getMMapLimit()));
                        dbman.putDatabase(db);
                    }
                    Logging.logMessage((int)6, (Object)this, (String)"loaded DB %s successfully. [LSN %s]", (Object[])new Object[]{dbName, db.getLSMDB().getOndiskLSN()});
                }
            }
            Set<Integer> outdatedIds = dbman.getAllDatabaseIds();
            outdatedIds.removeAll(ids);
            if (outdatedIds.size() > 0) {
                for (int id : outdatedIds) {
                    dbman.removeDatabaseById(id);
                }
            }
        }
        catch (InstantiationException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot instantiate comparator", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot instantiate comparator", ex);
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot load database config, check path and access rights", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot load database config, config file might be corrupted", ex);
        }
        catch (ClassCastException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot load database config, config file might be corrupted", ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void load() throws BabuDBException {
        DatabaseManagerInternal dbman = this.dbs.getDatabaseManager();
        assert (dbman != null) : "The DatabaseManager is not available!";
        ObjectInputStream ois = null;
        try {
            if (this.configFile.exists()) {
                ois = new ObjectInputStream(new FileInputStream(this.configFile));
                this.dbFormatVer = ois.readInt();
                if (this.dbFormatVer != 4) {
                    this.conversionRequired = true;
                }
                int numDB = ois.readInt();
                dbman.setNextDBId(ois.readInt());
                for (int i = 0; i < numDB; ++i) {
                    Logging.logMessage((int)7, (Object)this, (String)"loading DB...", (Object[])new Object[0]);
                    String dbName = (String)ois.readObject();
                    int dbId = ois.readInt();
                    int numIndex = ois.readInt();
                    ByteRangeComparator[] comps = new ByteRangeComparator[numIndex];
                    for (int idx = 0; idx < numIndex; ++idx) {
                        String className = (String)ois.readObject();
                        ByteRangeComparator comp = dbman.getComparatorInstances().get(className);
                        if (comp == null) {
                            Class<?> clazz = Class.forName(className);
                            comp = (ByteRangeComparator)clazz.newInstance();
                            dbman.getComparatorInstances().put(className, comp);
                        }
                        assert (comp != null);
                        comps[idx] = comp;
                    }
                    if (this.conversionRequired) continue;
                    DatabaseImpl db = new DatabaseImpl(this.dbs, new LSMDatabase(dbName, dbId, this.dbs.getConfig().getBaseDir() + dbName + File.separatorChar, numIndex, true, comps, this.dbs.getConfig().getCompression(), this.dbs.getConfig().getMaxNumRecordsPerBlock(), this.dbs.getConfig().getMaxBlockFileSize(), this.dbs.getConfig().getDisableMMap(), this.dbs.getConfig().getMMapLimit()));
                    dbman.putDatabase(db);
                    Logging.logMessage((int)7, (Object)this, (String)("loaded DB " + dbName + "(" + dbId + ") successfully."), (Object[])new Object[0]);
                }
            }
        }
        catch (InstantiationException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot instantiate comparator", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot instantiate comparator", ex);
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot load database config, check path and access rights", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot load database config, config file might be corrupted", ex);
        }
        catch (ClassCastException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot load database config, config file might be corrupted", ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) throws BabuDBException {
        DatabaseManagerInternal dbman = this.dbs.getDatabaseManager();
        Object object = dbman.getDBModificationLock();
        synchronized (object) {
            try {
                File tempFile = new File(filename + ".in_progress");
                FileOutputStream fos = new FileOutputStream(tempFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeInt(4);
                oos.writeInt(dbman.getAllDatabaseIds().size());
                oos.writeInt(dbman.getNextDBId());
                for (int dbId : dbman.getAllDatabaseIds()) {
                    LSMDatabase db = dbman.getDatabase(dbId).getLSMDB();
                    oos.writeObject(db.getDatabaseName());
                    oos.writeInt(dbId);
                    oos.writeInt(db.getIndexCount());
                    String[] compClasses = db.getComparatorClassNames();
                    for (int i = 0; i < db.getIndexCount(); ++i) {
                        oos.writeObject(compClasses[i]);
                    }
                }
                oos.flush();
                fos.flush();
                fos.getFD().sync();
                oos.close();
                File dbFile = new File(filename);
                boolean success = tempFile.renameTo(dbFile);
                if (!success) {
                    dbFile.delete();
                    tempFile.renameTo(dbFile);
                }
            }
            catch (IOException ex) {
                throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "unable to save database configuration", ex);
            }
        }
    }

    public void save() throws BabuDBException {
        this.save(this.dbs.getConfig().getBaseDir() + this.dbs.getConfig().getDbCfgFile());
    }

    public boolean isConversionRequired() {
        return this.conversionRequired;
    }

    public int getDBFormatVersion() {
        return this.dbFormatVer;
    }
}

