/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseInsertGroup;
import org.xtreemfs.babudb.api.database.DatabaseRequestResult;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.database.UserDefinedLookup;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.lsmdb.BabuDBInsertGroup;
import org.xtreemfs.babudb.lsmdb.InsertRecordGroup;
import org.xtreemfs.babudb.lsmdb.LSMDBRequest;
import org.xtreemfs.babudb.lsmdb.LSMDBWorker;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSMLookupInterface;
import org.xtreemfs.babudb.lsmdb.LSN;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.logging.Logging;

public class DatabaseImpl
implements DatabaseInternal {
    private final BabuDBInternal dbs;
    private LSMDatabase lsmDB;

    public DatabaseImpl(BabuDBInternal dbs, LSMDatabase lsmDB) {
        this.dbs = dbs;
        this.lsmDB = lsmDB;
    }

    @Override
    public void shutdown() throws BabuDBException {
        try {
            for (int index = 0; index < this.lsmDB.getIndexCount(); ++index) {
                this.lsmDB.getIndex(index).destroy();
            }
        }
        catch (IOException exc) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, exc.getMessage(), exc);
        }
    }

    @Override
    public BabuDBInsertGroup createInsertGroup() {
        return new BabuDBInsertGroup(this.lsmDB);
    }

    @Override
    public DatabaseRequestResult<Object> singleInsert(int indexId, byte[] key, byte[] value, Object context) {
        BabuDBInsertGroup irg = new BabuDBInsertGroup(this.lsmDB);
        irg.addInsert(indexId, key, value);
        return this.insert(irg, context);
    }

    @Override
    public DatabaseRequestResult<Object> insert(BabuDBInsertGroup irg, Object context) {
        InsertRecordGroup ins = irg.getRecord();
        int dbId = ins.getDatabaseId();
        LSMDBWorker w = this.dbs.getWorker(dbId);
        if (w != null) {
            if (Logging.isDebug()) {
                Logging.logMessage((int)7, (Object)this, (String)("insert request is sent to worker #" + dbId % this.dbs.getWorkerCount()), (Object[])new Object[0]);
            }
            BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(context, this.dbs.getResponseManager());
            try {
                w.addRequest(new LSMDBRequest(this.lsmDB, result, ins));
            }
            catch (InterruptedException ex) {
                result.failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "operation was interrupted", ex));
            }
            return result;
        }
        return this.directInsert(irg, context);
    }

    private DatabaseRequestResult<Object> directInsert(BabuDBInsertGroup irg, Object context) {
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(context, this.dbs.getResponseManager());
        try {
            this.dbs.getTransactionManager().makePersistent(this.dbs.getDatabaseManager().createTransaction().insertRecordGroup(this.getName(), irg.getRecord(), this.getLSMDB()), result);
        }
        catch (BabuDBException e) {
            result.failed(e);
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<byte[]> lookup(int indexId, byte[] key, Object context) {
        BabuDBRequestResultImpl<byte[]> result = new BabuDBRequestResultImpl<byte[]>(context, this.dbs.getResponseManager());
        LSMDBWorker w = this.dbs.getWorker(this.lsmDB.getDatabaseId());
        if (w != null) {
            if (Logging.isDebug()) {
                Logging.logMessage((int)7, (Object)this, (String)("lookup request is sent to worker #" + this.lsmDB.getDatabaseId() % this.dbs.getWorkerCount()), (Object[])new Object[0]);
            }
            try {
                w.addRequest(new LSMDBRequest<byte[]>(this.lsmDB, indexId, result, key));
            }
            catch (InterruptedException ex) {
                result.failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "operation was interrupted", ex));
            }
        } else {
            this.directLookup(indexId, key, result);
        }
        return result;
    }

    private void directLookup(int indexId, byte[] key, BabuDBRequestResultImpl<byte[]> listener) {
        if (indexId >= this.lsmDB.getIndexCount() || indexId < 0) {
            listener.failed(new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index does not exist"));
        } else {
            listener.finished(this.lsmDB.getIndex(indexId).lookup(key));
        }
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> prefixLookup(int indexId, byte[] key, Object context) {
        return this.prefixLookup(indexId, key, context, true);
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reversePrefixLookup(int indexId, byte[] key, Object context) {
        return this.prefixLookup(indexId, key, context, false);
    }

    private DatabaseRequestResult<ResultSet<byte[], byte[]>> prefixLookup(int indexId, byte[] key, Object context, boolean ascending) {
        BabuDBRequestResultImpl<ResultSet<byte[], byte[]>> result = new BabuDBRequestResultImpl<ResultSet<byte[], byte[]>>(context, this.dbs.getResponseManager());
        LSMDBWorker w = this.dbs.getWorker(this.lsmDB.getDatabaseId());
        if (w != null) {
            if (Logging.isDebug() && w != null) {
                Logging.logMessage((int)7, (Object)this, (String)("lookup request is sent to worker #" + this.lsmDB.getDatabaseId() % this.dbs.getWorkerCount()), (Object[])new Object[0]);
            }
            try {
                w.addRequest(new LSMDBRequest(this.lsmDB, indexId, result, key, ascending));
            }
            catch (InterruptedException ex) {
                result.failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "operation was interrupted", ex));
            }
        } else if (indexId >= this.lsmDB.getIndexCount() || indexId < 0) {
            result.failed(new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index does not exist"));
        } else {
            result.finished(this.lsmDB.getIndex(indexId).prefixLookup(key, ascending));
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> rangeLookup(int indexId, byte[] from, byte[] to, Object context) {
        return this.rangeLookup(indexId, from, to, context, true);
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reverseRangeLookup(int indexId, byte[] from, byte[] to, Object context) {
        return this.rangeLookup(indexId, from, to, context, false);
    }

    private DatabaseRequestResult<ResultSet<byte[], byte[]>> rangeLookup(int indexId, byte[] from, byte[] to, Object context, boolean ascending) {
        BabuDBRequestResultImpl<ResultSet<byte[], byte[]>> result = new BabuDBRequestResultImpl<ResultSet<byte[], byte[]>>(context, this.dbs.getResponseManager());
        LSMDBWorker w = this.dbs.getWorker(this.lsmDB.getDatabaseId());
        if (w != null) {
            if (Logging.isDebug() && w != null) {
                Logging.logMessage((int)7, (Object)this, (String)("lookup request is sent to worker #" + this.lsmDB.getDatabaseId() % this.dbs.getWorkerCount()), (Object[])new Object[0]);
            }
            try {
                w.addRequest(new LSMDBRequest(this.lsmDB, indexId, result, from, to, ascending));
            }
            catch (InterruptedException ex) {
                result.failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "operation was interrupted", ex));
            }
        } else if (indexId >= this.lsmDB.getIndexCount() || indexId < 0) {
            result.failed(new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index does not exist"));
        } else {
            result.finished(this.lsmDB.getIndex(indexId).rangeLookup(from, to, ascending));
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<Object> userDefinedLookup(UserDefinedLookup udl, Object context) {
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(context, this.dbs.getResponseManager());
        LSMDBWorker w = this.dbs.getWorker(this.lsmDB.getDatabaseId());
        if (w != null) {
            if (Logging.isNotice()) {
                Logging.logMessage((int)5, (Object)this, (String)("udl request is sent to worker #" + this.lsmDB.getDatabaseId() % this.dbs.getWorkerCount()), (Object[])new Object[0]);
            }
            try {
                w.addRequest(new LSMDBRequest<Object>(this.lsmDB, result, udl));
            }
            catch (InterruptedException ex) {
                result.failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "operation was interrupted", ex));
            }
        } else {
            this.directUserDefinedLookup(udl, result);
        }
        return result;
    }

    private void directUserDefinedLookup(UserDefinedLookup udl, BabuDBRequestResultImpl<Object> listener) {
        LSMLookupInterface lif = new LSMLookupInterface(this.lsmDB);
        try {
            Object result = udl.execute(lif);
            listener.finished(result);
        }
        catch (BabuDBException e) {
            listener.failed(e);
        }
    }

    @Override
    public byte[] directLookup(int indexId, int snapId, byte[] key) throws BabuDBException {
        if (indexId >= this.lsmDB.getIndexCount() || indexId < 0) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index does not exist");
        }
        return this.lsmDB.getIndex(indexId).lookup(key, snapId);
    }

    @Override
    public ResultSet<byte[], byte[]> directPrefixLookup(int indexId, int snapId, byte[] key, boolean ascending) throws BabuDBException {
        if (indexId >= this.lsmDB.getIndexCount() || indexId < 0) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index does not exist");
        }
        return this.lsmDB.getIndex(indexId).prefixLookup(key, snapId, ascending);
    }

    @Override
    public ResultSet<byte[], byte[]> directRangeLookup(int indexId, int snapId, byte[] from, byte[] to, boolean ascending) throws BabuDBException {
        if (indexId >= this.lsmDB.getIndexCount() || indexId < 0) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index does not exist");
        }
        return this.lsmDB.getIndex(indexId).rangeLookup(from, to, snapId, ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proceedSnapshot(String destDB) throws BabuDBException, InterruptedException {
        int[] ids;
        try {
            this.dbs.getTransactionManager().lockService();
            ids = this.lsmDB.createSnapshot();
        }
        finally {
            this.dbs.getTransactionManager().unlockService();
        }
        File dbDir = new File(this.dbs.getConfig().getBaseDir() + destDB);
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
        try {
            LSN lsn = this.lsmDB.getOndiskLSN();
            this.lsmDB.writeSnapshot(this.dbs.getConfig().getBaseDir() + destDB + File.separatorChar, ids, lsn.getViewId(), lsn.getSequenceNo());
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot write snapshot: " + ex, ex.getCause());
        }
    }

    @Override
    public int[] proceedCreateSnapshot() {
        return this.lsmDB.createSnapshot();
    }

    @Override
    public void proceedWriteSnapshot(int[] snapIds, String directory, SnapshotConfig cfg) throws BabuDBException {
        try {
            this.lsmDB.writeSnapshot(directory, snapIds, cfg);
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot write snapshot: " + ex, ex);
        }
    }

    public void writeSnapshot(int viewId, long sequenceNo, int[] snapIds) throws BabuDBException {
        this.proceedWriteSnapshot(viewId, sequenceNo, snapIds);
    }

    @Override
    public void proceedWriteSnapshot(int viewId, long sequenceNo, int[] snapIds) throws BabuDBException {
        try {
            this.lsmDB.writeSnapshot(viewId, sequenceNo, snapIds);
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot write snapshot: " + ex, ex);
        }
    }

    @Override
    public void proceedCleanupSnapshot(int viewId, long sequenceNo) throws BabuDBException {
        try {
            this.lsmDB.cleanupSnapshot(viewId, sequenceNo);
        }
        catch (ClosedByInterruptException ex) {
            Logging.logError((int)7, (Object)this, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot clean up: " + ex, ex);
        }
    }

    @Override
    public void dumpSnapshot(String baseDir) throws BabuDBException {
        baseDir = baseDir.endsWith(File.separator) ? baseDir : baseDir + File.separator;
        String destDir = baseDir + this.lsmDB.getDatabaseName();
        try {
            int[] ids = this.lsmDB.createSnapshot();
            LSN lsn = this.lsmDB.getOndiskLSN();
            this.lsmDB.writeSnapshot(destDir, ids, lsn.getViewId(), lsn.getSequenceNo());
        }
        catch (IOException ex) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "cannot write snapshot: " + ex, ex);
        }
    }

    @Override
    public void setLSMDB(LSMDatabase lsmDatabase) {
        this.lsmDB = lsmDatabase;
    }

    @Override
    public LSMDatabase getLSMDB() {
        return this.lsmDB;
    }

    @Override
    public ByteRangeComparator[] getComparators() {
        return this.lsmDB.getComparators();
    }

    @Override
    public String getName() {
        return this.lsmDB.getDatabaseName();
    }

    @Override
    public DatabaseRequestResult<Object> insert(DatabaseInsertGroup irg, Object context) {
        return this.insert((BabuDBInsertGroup)irg, context);
    }
}

