/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.database.DatabaseRequestResult;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.CheckpointerInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.dev.DatabaseManagerInternal;
import org.xtreemfs.babudb.api.dev.transaction.InMemoryProcessing;
import org.xtreemfs.babudb.api.dev.transaction.OperationInternal;
import org.xtreemfs.babudb.api.dev.transaction.TransactionInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.api.transaction.Transaction;
import org.xtreemfs.babudb.api.transaction.TransactionListener;
import org.xtreemfs.babudb.config.BabuDBConfig;
import org.xtreemfs.babudb.index.DefaultByteRangeComparator;
import org.xtreemfs.babudb.index.LSMTree;
import org.xtreemfs.babudb.lsmdb.BabuDBTransaction;
import org.xtreemfs.babudb.lsmdb.DatabaseImpl;
import org.xtreemfs.babudb.lsmdb.InsertRecordGroup;
import org.xtreemfs.babudb.lsmdb.LSMDBRequest;
import org.xtreemfs.babudb.lsmdb.LSMDBWorker;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.FSUtils;

public class DatabaseManagerImpl
implements DatabaseManagerInternal {
    private static final String RUNTIME_STATE_DBCREATIONCOUNT = "databaseManager.dbCreationCount";
    private static final String RUNTIME_STATE_DBDELETIONCOUNT = "databaseManager.dbDeletionCount";
    private BabuDBInternal dbs;
    private final Map<String, DatabaseInternal> dbsByName;
    private final Map<Integer, DatabaseInternal> dbsById;
    private final Map<String, ByteRangeComparator> compInstances;
    private int nextDbId;
    private final Object dbModificationLock;
    private AtomicInteger _dbCreationCount = new AtomicInteger();
    private AtomicInteger _dbDeletionCount = new AtomicInteger();

    public DatabaseManagerImpl(BabuDBInternal dbs) throws BabuDBException {
        this.dbs = dbs;
        this.dbsByName = new HashMap<String, DatabaseInternal>();
        this.dbsById = new HashMap<Integer, DatabaseInternal>();
        this.compInstances = new HashMap<String, ByteRangeComparator>();
        this.compInstances.put(DefaultByteRangeComparator.class.getName(), new DefaultByteRangeComparator());
        this.nextDbId = 1;
        this.dbModificationLock = new Object();
        this.initializeTransactionManager();
    }

    @Override
    public void reset() throws BabuDBException {
        this.nextDbId = 1;
        this.compInstances.clear();
        this.compInstances.put(DefaultByteRangeComparator.class.getName(), new DefaultByteRangeComparator());
        this.dbs.getDBConfigFile().reset();
    }

    @Override
    public Map<String, Database> getDatabases() {
        return new HashMap<String, Database>(this.getDatabasesInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DatabaseInternal> getDatabasesInternal() {
        Object object = this.dbModificationLock;
        synchronized (object) {
            return new HashMap<String, DatabaseInternal>(this.dbsByName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DatabaseInternal> getDatabaseList() {
        Object object = this.dbModificationLock;
        synchronized (object) {
            return new ArrayList<DatabaseInternal>(this.dbsById.values());
        }
    }

    @Override
    public DatabaseInternal getDatabase(String dbName) throws BabuDBException {
        DatabaseInternal db = this.dbsByName.get(dbName);
        if (db == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_DB, "database with name " + dbName + " does not exist");
        }
        return db;
    }

    @Override
    public DatabaseInternal getDatabase(int dbId) throws BabuDBException {
        DatabaseInternal db = this.dbsById.get(dbId);
        if (db == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_DB, "database (" + dbId + ") does not exist");
        }
        return db;
    }

    @Override
    public DatabaseInternal createDatabase(String databaseName, int numIndices) throws BabuDBException {
        return this.createDatabase(databaseName, numIndices, null);
    }

    @Override
    public DatabaseInternal createDatabase(String databaseName, int numIndices, ByteRangeComparator[] comparators) throws BabuDBException {
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(this.dbs.getResponseManager());
        this.dbs.getTransactionManager().makePersistent(this.createTransaction().createDatabase(databaseName, numIndices, comparators), result);
        Object obj = ((Object[])result.get())[0];
        this._dbCreationCount.incrementAndGet();
        return (DatabaseInternal)obj;
    }

    @Override
    public void deleteDatabase(String databaseName) throws BabuDBException {
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(this.dbs.getResponseManager());
        this.dbs.getTransactionManager().makePersistent(this.createTransaction().deleteDatabase(databaseName), result);
        result.get();
        this._dbDeletionCount.incrementAndGet();
    }

    @Override
    public void copyDatabase(String sourceDB, String destDB) throws BabuDBException {
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(this.dbs.getResponseManager());
        this.dbs.getTransactionManager().makePersistent(this.createTransaction().copyDatabase(sourceDB, destDB), result);
        result.get();
    }

    @Override
    public void shutdown() throws BabuDBException {
        for (Database database : this.dbsById.values()) {
            database.shutdown();
        }
        Logging.logMessage((int)7, (Object)this, (String)"DB manager shut down successfully", (Object[])new Object[0]);
    }

    @Override
    public Object getDBModificationLock() {
        return this.dbModificationLock;
    }

    @Override
    public void dumpAllDatabases(String destPath) throws BabuDBException, InterruptedException, IOException {
        File dir = new File(destPath = destPath.endsWith(File.separator) ? destPath : destPath + File.separator);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Directory doesnt exist and cannot be created:'" + destPath + "'");
        }
        BabuDBConfig cfg = this.dbs.getConfig();
        this.dbs.getDBConfigFile().save(destPath + cfg.getDbCfgFile());
        for (DatabaseInternal db : this.dbsByName.values()) {
            db.dumpSnapshot(destPath);
        }
    }

    private void initializeTransactionManager() {
        this.dbs.getTransactionManager().registerInMemoryProcessing((byte)2, new InMemoryProcessing(){

            @Override
            public Object[] deserializeRequest(ReusableBuffer serialized) throws BabuDBException {
                serialized.getInt();
                String dbName = serialized.getString();
                int indices = serialized.getInt();
                serialized.flip();
                return new Object[]{dbName, indices, null};
            }

            @Override
            public OperationInternal convertToOperation(Object[] args) {
                return new BabuDBTransaction.BabuDBOperation(2, (String)args[0], new Object[]{args[1], args[2]});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DatabaseInternal process(OperationInternal operation) throws BabuDBException {
                Object[] args = operation.getParams();
                int numIndices = (Integer)args[0];
                ByteRangeComparator[] com = null;
                if (args.length > 2) {
                    com = (ByteRangeComparator[])args[1];
                }
                if (com == null) {
                    ByteRangeComparator[] comps = new ByteRangeComparator[numIndices];
                    ByteRangeComparator defaultComparator = (ByteRangeComparator)DatabaseManagerImpl.this.compInstances.get(DefaultByteRangeComparator.class.getName());
                    for (int i = 0; i < numIndices; ++i) {
                        comps[i] = defaultComparator;
                    }
                    com = comps;
                }
                DatabaseImpl db = null;
                Object object = DatabaseManagerImpl.this.getDBModificationLock();
                synchronized (object) {
                    CheckpointerInternal checkpointerInternal = DatabaseManagerImpl.this.dbs.getCheckpointer();
                    synchronized (checkpointerInternal) {
                        if (DatabaseManagerImpl.this.dbsByName.containsKey(operation.getDatabaseName())) {
                            throw new BabuDBException(BabuDBException.ErrorCode.DB_EXISTS, "database '" + operation.getDatabaseName() + "' already exists");
                        }
                        int dbId = DatabaseManagerImpl.this.nextDbId++;
                        db = new DatabaseImpl(DatabaseManagerImpl.this.dbs, new LSMDatabase(operation.getDatabaseName(), dbId, DatabaseManagerImpl.this.dbs.getConfig().getBaseDir() + operation.getDatabaseName() + File.separatorChar, numIndices, false, com, DatabaseManagerImpl.this.dbs.getConfig().getCompression(), DatabaseManagerImpl.this.dbs.getConfig().getMaxNumRecordsPerBlock(), DatabaseManagerImpl.this.dbs.getConfig().getMaxBlockFileSize(), DatabaseManagerImpl.this.dbs.getConfig().getDisableMMap(), DatabaseManagerImpl.this.dbs.getConfig().getMMapLimit()));
                        DatabaseManagerImpl.this.dbsById.put(dbId, db);
                        DatabaseManagerImpl.this.dbsByName.put(operation.getDatabaseName(), db);
                        DatabaseManagerImpl.this.dbs.getDBConfigFile().save();
                    }
                }
                return db;
            }
        });
        this.dbs.getTransactionManager().registerInMemoryProcessing((byte)4, new InMemoryProcessing(){

            @Override
            public Object[] deserializeRequest(ReusableBuffer serialized) throws BabuDBException {
                serialized.getInt();
                String dbName = serialized.getString();
                serialized.flip();
                return new Object[]{dbName};
            }

            @Override
            public OperationInternal convertToOperation(Object[] args) {
                return new BabuDBTransaction.BabuDBOperation(4, (String)args[0], null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object process(OperationInternal operation) throws BabuDBException {
                int dbId = -1;
                Object object = DatabaseManagerImpl.this.getDBModificationLock();
                synchronized (object) {
                    CheckpointerInternal checkpointerInternal = DatabaseManagerImpl.this.dbs.getCheckpointer();
                    synchronized (checkpointerInternal) {
                        if (!DatabaseManagerImpl.this.dbsByName.containsKey(operation.getDatabaseName())) {
                            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_DB, "database '" + operation.getDatabaseName() + "' does not exists");
                        }
                        LSMDatabase db = DatabaseManagerImpl.this.getDatabase(operation.getDatabaseName()).getLSMDB();
                        dbId = db.getDatabaseId();
                        DatabaseManagerImpl.this.dbsByName.remove(operation.getDatabaseName());
                        DatabaseManagerImpl.this.dbsById.remove(dbId);
                        DatabaseManagerImpl.this.dbs.getSnapshotManager().deleteAllSnapshots(operation.getDatabaseName());
                        DatabaseManagerImpl.this.dbs.getDBConfigFile().save();
                        File dbDir = new File(DatabaseManagerImpl.this.dbs.getConfig().getBaseDir(), operation.getDatabaseName());
                        if (dbDir.exists()) {
                            FSUtils.delTree((File)dbDir);
                        }
                    }
                }
                return null;
            }
        });
        this.dbs.getTransactionManager().registerInMemoryProcessing((byte)3, new InMemoryProcessing(){

            @Override
            public Object[] deserializeRequest(ReusableBuffer serialized) throws BabuDBException {
                serialized.getInt();
                serialized.getInt();
                String sourceDB = serialized.getString();
                String destDB = serialized.getString();
                serialized.flip();
                return new Object[]{sourceDB, destDB};
            }

            @Override
            public OperationInternal convertToOperation(Object[] args) {
                return new BabuDBTransaction.BabuDBOperation(3, (String)args[0], new Object[]{args[1]});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object process(OperationInternal operation) throws BabuDBException {
                int dbId;
                Object object;
                String destDB = (String)operation.getParams()[0];
                DatabaseInternal sDB = DatabaseManagerImpl.this.getDatabase(operation.getDatabaseName());
                Object object2 = DatabaseManagerImpl.this.getDBModificationLock();
                synchronized (object2) {
                    object = DatabaseManagerImpl.this.dbs.getCheckpointer();
                    synchronized (object) {
                        if (DatabaseManagerImpl.this.dbsByName.containsKey(destDB)) {
                            throw new BabuDBException(BabuDBException.ErrorCode.DB_EXISTS, "database '" + destDB + "' already exists");
                        }
                        dbId = DatabaseManagerImpl.this.nextDbId++;
                        DatabaseManagerImpl.this.dbsByName.put(destDB, null);
                        DatabaseManagerImpl.this.dbs.getDBConfigFile().save();
                    }
                }
                try {
                    sDB.proceedSnapshot(destDB);
                }
                catch (InterruptedException i) {
                    throw new BabuDBException(BabuDBException.ErrorCode.INTERNAL_ERROR, "Snapshot creation was interrupted.", i);
                }
                DatabaseImpl newDB = new DatabaseImpl(DatabaseManagerImpl.this.dbs, new LSMDatabase(destDB, dbId, DatabaseManagerImpl.this.dbs.getConfig().getBaseDir() + destDB + File.separatorChar, sDB.getLSMDB().getIndexCount(), true, sDB.getComparators(), DatabaseManagerImpl.this.dbs.getConfig().getCompression(), DatabaseManagerImpl.this.dbs.getConfig().getMaxNumRecordsPerBlock(), DatabaseManagerImpl.this.dbs.getConfig().getMaxBlockFileSize(), DatabaseManagerImpl.this.dbs.getConfig().getDisableMMap(), DatabaseManagerImpl.this.dbs.getConfig().getMMapLimit()));
                object = DatabaseManagerImpl.this.dbModificationLock;
                synchronized (object) {
                    DatabaseManagerImpl.this.dbsById.put(dbId, newDB);
                    DatabaseManagerImpl.this.dbsByName.put(destDB, newDB);
                    DatabaseManagerImpl.this.dbs.getDBConfigFile().save();
                }
                return null;
            }
        });
        this.dbs.getTransactionManager().registerInMemoryProcessing((byte)0, new InMemoryProcessing(){

            @Override
            public Object[] deserializeRequest(ReusableBuffer serialized) throws BabuDBException {
                InsertRecordGroup irg = InsertRecordGroup.deserialize(serialized);
                serialized.flip();
                return new Object[]{irg, null};
            }

            @Override
            public OperationInternal convertToOperation(Object[] args) {
                return new BabuDBTransaction.BabuDBOperation(0, null, new Object[]{args[0]});
            }

            @Override
            public Object process(OperationInternal operation) throws BabuDBException {
                Object[] args = operation.getParams();
                InsertRecordGroup irg = (InsertRecordGroup)args[0];
                LSMDatabase lsmDB = null;
                if (args.length > 1 && args[1] instanceof LSMDatabase) {
                    lsmDB = (LSMDatabase)args[1];
                }
                if (lsmDB == null) {
                    if (irg.getDatabaseId() == -1) {
                        irg.setDatabaseId(DatabaseManagerImpl.this.getDatabase(operation.getDatabaseName()).getLSMDB().getDatabaseId());
                    }
                    lsmDB = DatabaseManagerImpl.this.getDatabase(irg.getDatabaseId()).getLSMDB();
                    operation.updateParams(new Object[]{irg, lsmDB});
                }
                if (operation.getDatabaseName() == null) {
                    operation.updateDatabaseName(lsmDB.getDatabaseName());
                }
                int numIndices = lsmDB.getIndexCount();
                for (InsertRecordGroup.InsertRecord ir : irg.getInserts()) {
                    if (ir.getIndexId() < numIndices && ir.getIndexId() >= 0) continue;
                    throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + ir.getIndexId() + " does not exist");
                }
                for (InsertRecordGroup.InsertRecord ir : irg.getInserts()) {
                    LSMTree index = lsmDB.getIndex(ir.getIndexId());
                    if (ir.getValue() != null) {
                        index.insert(ir.getKey(), ir.getValue());
                        continue;
                    }
                    index.delete(ir.getKey());
                }
                return null;
            }
        });
    }

    @Override
    public void setNextDBId(int id) {
        this.nextDbId = id;
    }

    @Override
    public Map<String, ByteRangeComparator> getComparatorInstances() {
        return this.compInstances;
    }

    @Override
    public void putDatabase(DatabaseInternal database) {
        this.dbsById.put(database.getLSMDB().getDatabaseId(), database);
        this.dbsByName.put(database.getName(), database);
    }

    @Override
    public Set<Integer> getAllDatabaseIds() {
        return new HashSet<Integer>(this.dbsById.keySet());
    }

    @Override
    public void removeDatabaseById(int id) {
        this.dbsByName.remove(this.dbsById.remove(id).getName());
    }

    @Override
    public int getNextDBId() {
        return this.nextDbId;
    }

    @Override
    public TransactionInternal createTransaction() {
        return new BabuDBTransaction();
    }

    @Override
    public synchronized void executeTransaction(TransactionInternal txn) throws BabuDBException {
        if (this.dbs.getWorkerCount() > 0) {
            HashMap workerLockFutureMap = new HashMap();
            HashMap<String, DatabaseRequestResult<AtomicBoolean>> databaseLockFutureMap = new HashMap<String, DatabaseRequestResult<AtomicBoolean>>();
            for (String dbName : txn.databasesAffected()) {
                try {
                    if (databaseLockFutureMap.containsKey(dbName)) continue;
                    LSMDBWorker worker = this.dbs.getWorker(this.getDatabase(dbName).getLSMDB().getDatabaseId());
                    BabuDBRequestResultImpl lockFuture = (BabuDBRequestResultImpl)workerLockFutureMap.get((Object)worker);
                    if (lockFuture == null) {
                        lockFuture = new BabuDBRequestResultImpl(txn, this.dbs.getResponseManager());
                        worker.addRequest(new LSMDBRequest(lockFuture));
                        workerLockFutureMap.put(worker, lockFuture);
                    }
                    databaseLockFutureMap.put(dbName, lockFuture);
                }
                catch (BabuDBException be) {
                    assert (be.getErrorCode() == BabuDBException.ErrorCode.NO_SUCH_DB);
                }
                catch (InterruptedException ie) {
                    throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, ie.getMessage(), ie);
                }
            }
            txn.updateWorkerLocks(databaseLockFutureMap);
        }
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(this.dbs.getResponseManager());
        this.dbs.getTransactionManager().makePersistent(txn, result);
        result.get();
    }

    @Override
    public void executeTransaction(Transaction txn) throws BabuDBException {
        this.executeTransaction((TransactionInternal)txn);
    }

    @Override
    public void addTransactionListener(TransactionListener listener) {
        this.dbs.getTransactionManager().addTransactionListener(listener);
    }

    @Override
    public void removeTransactionListener(TransactionListener listener) {
        this.dbs.getTransactionManager().removeTransactionListener(listener);
    }

    @Override
    public Object getRuntimeState(String property) {
        if (RUNTIME_STATE_DBCREATIONCOUNT.equals(property)) {
            return this._dbCreationCount.get();
        }
        if (RUNTIME_STATE_DBDELETIONCOUNT.equals(property)) {
            return this._dbDeletionCount.get();
        }
        return null;
    }

    @Override
    public Map<String, Object> getRuntimeState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RUNTIME_STATE_DBCREATIONCOUNT, this._dbCreationCount.get());
        map.put(RUNTIME_STATE_DBDELETIONCOUNT, this._dbDeletionCount.get());
        return map;
    }
}

