/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class InsertRecordGroup {
    public static final int DB_ID_UNKNOWN = -1;
    private final List<InsertRecord> records = new LinkedList<InsertRecord>();
    private int databaseId = -1;

    public InsertRecordGroup() {
    }

    public InsertRecordGroup(int databaseId) {
        this.databaseId = databaseId;
    }

    public void addInsert(int indexId, byte[] key, byte[] value) {
        this.records.add(new InsertRecord(indexId, key, value));
    }

    public List<InsertRecord> getInserts() {
        return this.records;
    }

    public void setDatabaseId(int id) {
        this.databaseId = id;
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    private void addInsertRecord(InsertRecord rec) {
        assert (rec != null);
        this.records.add(rec);
    }

    public int getSize() {
        int size = 4;
        for (InsertRecord ir : this.records) {
            size += ir.getSize();
        }
        return size;
    }

    public void serialize(ReusableBuffer buffer) {
        buffer.putInt(this.databaseId);
        for (InsertRecord ir : this.records) {
            ir.serialize(buffer);
        }
    }

    public static InsertRecordGroup deserialize(ReusableBuffer buffer) {
        int dbId = buffer.getInt();
        InsertRecordGroup ai = new InsertRecordGroup(dbId);
        while (buffer.hasRemaining()) {
            InsertRecord ir = InsertRecord.deserialize(buffer);
            ai.addInsertRecord(ir);
        }
        return ai;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName() + "\n");
        sb.append("database: " + this.databaseId + "\n");
        for (InsertRecord record : this.records) {
            sb.append(record + "\n");
        }
        return sb.toString();
    }

    public static class InsertRecord {
        private final byte indexId;
        private final byte[] key;
        private final byte[] value;

        public InsertRecord(int indexId, byte[] key, byte[] value) {
            this.indexId = (byte)indexId;
            this.key = key;
            this.value = value;
        }

        public int getIndexId() {
            return 0xFF & this.indexId;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public int getSize() {
            if (this.value != null) {
                return 9 + this.key.length + this.value.length;
            }
            return 9 + this.key.length;
        }

        public void serialize(ReusableBuffer buffer) {
            buffer.put(this.indexId);
            buffer.putInt(this.key.length);
            buffer.put(this.key);
            if (this.value != null) {
                buffer.putInt(this.value.length);
                buffer.put(this.value);
            } else {
                buffer.putInt(0);
            }
        }

        public static InsertRecord deserialize(ReusableBuffer buffer) {
            byte tmp = buffer.get();
            int indexId = 0xFF & tmp;
            int size = buffer.getInt();
            byte[] key = new byte[size];
            buffer.get(key);
            size = buffer.getInt();
            byte[] value = null;
            if (size > 0) {
                value = new byte[size];
                buffer.get(value);
            }
            return new InsertRecord(indexId, key, value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("index: " + this.indexId);
            sb.append(", key: " + (this.key == null ? null : Arrays.toString(this.key)));
            sb.append(", value: " + (this.value == null ? null : Arrays.toString(this.value)));
            return sb.toString();
        }
    }
}

