/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.UserDefinedLookup;
import org.xtreemfs.babudb.lsmdb.InsertRecordGroup;
import org.xtreemfs.babudb.lsmdb.LSMDBWorker;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;

public class LSMDBRequest<T> {
    private final BabuDBRequestResultImpl<T> listener;
    private final LSMDatabase database;
    private final int indexId;
    private final LSMDBWorker.RequestOperation operation;
    private final InsertRecordGroup insertData;
    private final byte[] lookupKey;
    private byte[] from;
    private byte[] to;
    private boolean ascending;
    private final UserDefinedLookup udLookup;

    public LSMDBRequest(BabuDBRequestResultImpl<T> listener) {
        this.operation = LSMDBWorker.RequestOperation.LOCK;
        this.listener = listener;
        this.udLookup = null;
        this.lookupKey = null;
        this.insertData = null;
        this.indexId = -1;
        this.database = null;
    }

    public LSMDBRequest(LSMDatabase database, BabuDBRequestResultImpl<T> listener, InsertRecordGroup insert) {
        this.operation = LSMDBWorker.RequestOperation.INSERT;
        this.database = database;
        this.indexId = 0;
        this.insertData = insert;
        this.lookupKey = null;
        this.listener = listener;
        this.udLookup = null;
    }

    public LSMDBRequest(LSMDatabase database, int indexId, BabuDBRequestResultImpl<T> listener, byte[] key) {
        this.operation = LSMDBWorker.RequestOperation.LOOKUP;
        this.database = database;
        this.indexId = indexId;
        this.lookupKey = key;
        this.insertData = null;
        this.listener = listener;
        this.udLookup = null;
    }

    public LSMDBRequest(LSMDatabase database, int indexId, BabuDBRequestResultImpl<T> listener, byte[] prefix, boolean ascending) {
        this.operation = LSMDBWorker.RequestOperation.PREFIX_LOOKUP;
        this.database = database;
        this.indexId = indexId;
        this.lookupKey = prefix;
        this.insertData = null;
        this.listener = listener;
        this.udLookup = null;
        this.ascending = ascending;
    }

    public LSMDBRequest(LSMDatabase database, int indexId, BabuDBRequestResultImpl<T> listener, byte[] from, byte[] to, boolean ascending) {
        this.operation = LSMDBWorker.RequestOperation.RANGE_LOOKUP;
        this.database = database;
        this.indexId = indexId;
        this.from = from;
        this.to = to;
        this.lookupKey = null;
        this.insertData = null;
        this.listener = listener;
        this.udLookup = null;
        this.ascending = ascending;
    }

    public LSMDBRequest(LSMDatabase database, BabuDBRequestResultImpl<T> listener, UserDefinedLookup udLookup) {
        this.operation = LSMDBWorker.RequestOperation.USER_DEFINED_LOOKUP;
        this.database = database;
        this.indexId = 0;
        this.lookupKey = null;
        this.insertData = null;
        this.listener = listener;
        this.udLookup = udLookup;
    }

    public LSMDatabase getDatabase() {
        return this.database;
    }

    public int getIndexId() {
        return this.indexId;
    }

    public LSMDBWorker.RequestOperation getOperation() {
        return this.operation;
    }

    public InsertRecordGroup getInsertData() {
        return this.insertData;
    }

    public byte[] getLookupKey() {
        return this.lookupKey;
    }

    public byte[] getFrom() {
        return this.from;
    }

    public byte[] getTo() {
        return this.to;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public BabuDBRequestResultImpl<T> getListener() {
        return this.listener;
    }

    public UserDefinedLookup getUserDefinedLookup() {
        return this.udLookup;
    }
}

