/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.babudb.api.database.UserDefinedLookup;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.lsmdb.LSMDBRequest;
import org.xtreemfs.babudb.lsmdb.LSMDatabase;
import org.xtreemfs.babudb.lsmdb.LSMLookupInterface;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;

public class LSMDBWorker
extends LifeCycleThread {
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private final BabuDBInternal dbs;
    private final LinkedList<LSMDBRequest<?>> requests = new LinkedList();
    private final int maxQ;
    private boolean quit = true;
    private boolean graceful;

    public LSMDBWorker(BabuDBInternal babuDB, int id, int maxQ) {
        super("LSMDBWrkr#" + id);
        this.setLifeCycleListener(babuDB);
        this.maxQ = maxQ;
        this.dbs = babuDB;
    }

    public synchronized void addRequest(LSMDBRequest<?> request) throws InterruptedException {
        assert (request != null);
        if (!this.quit && this.maxQ > 0 && this.requests.size() >= this.maxQ) {
            ((Object)((Object)this)).wait();
        }
        if (!this.quit) {
            assert (this.maxQ == 0 || this.requests.size() < this.maxQ);
        } else {
            throw new InterruptedException("Appending a request to the queue of " + this.getName() + " was interrupted, due shutdown.");
        }
        this.requests.add(request);
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void shutdown(boolean graceful) {
        this.graceful = graceful;
        this.quit = true;
        ((Object)((Object)this)).notifyAll();
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public synchronized void start() {
        assert (this.quit);
        this.quit = false;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logging.logMessage((int)7, (Object)((Object)this), (String)"operational", (Object[])new Object[0]);
        this.notifyStarted();
        while (!this.quit) {
            try {
                LSMDBRequest<?> r;
                LSMDBWorker lSMDBWorker = this;
                synchronized (lSMDBWorker) {
                    if (this.requests.isEmpty()) {
                        ((Object)((Object)this)).wait();
                    }
                    if (this.quit) {
                        break;
                    }
                    r = this.requests.poll();
                    ((Object)((Object)this)).notify();
                }
                this.processRequest(r);
            }
            catch (InterruptedException ex) {
                if (this.quit) continue;
                this.cleanUp();
                this.notifyCrashed(ex);
                return;
            }
        }
        if (this.graceful) {
            LinkedList<LSMDBRequest<?>> linkedList = this.requests;
            synchronized (linkedList) {
                for (LSMDBRequest lSMDBRequest : this.requests) {
                    this.processRequest(lSMDBRequest);
                }
            }
        }
        Logging.logMessage((int)7, (Object)((Object)this), (String)"worker shutdown complete", (Object[])new Object[0]);
        this.notifyStopped();
    }

    private synchronized void cleanUp() {
        assert (this.graceful || this.requests.size() == 0);
        for (LSMDBRequest lSMDBRequest : this.requests) {
            lSMDBRequest.getListener().failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, "Worker was shut down, before the request could be proceeded."));
        }
    }

    private void processRequest(LSMDBRequest<?> r) {
        switch (r.getOperation()) {
            case INSERT: {
                this.doInsert(r);
                break;
            }
            case LOOKUP: {
                this.doLookup(r);
                break;
            }
            case PREFIX_LOOKUP: {
                this.doPrefixLookup(r);
                break;
            }
            case RANGE_LOOKUP: {
                this.doRangeLookup(r);
                break;
            }
            case USER_DEFINED_LOOKUP: {
                this.doUserLookup(r);
                break;
            }
            case LOCK: {
                this.doLock(r);
                break;
            }
            default: {
                Logging.logMessage((int)3, (Object)((Object)this), (String)"UNKNOWN OPERATION REQUESTED! PROGRAMMATIC ERROR!!!! PANIC!", (Object[])new Object[0]);
                System.exit(1);
            }
        }
    }

    private void doUserLookup(LSMDBRequest<Object> r) {
        UserDefinedLookup l = r.getUserDefinedLookup();
        LSMLookupInterface lif = new LSMLookupInterface(r.getDatabase());
        try {
            Object result = l.execute(lif);
            r.getListener().finished(result);
        }
        catch (BabuDBException ex) {
            r.getListener().failed(ex);
        }
    }

    private void doInsert(LSMDBRequest<?> r) {
        try {
            this.dbs.getTransactionManager().makePersistent(this.dbs.getDatabaseManager().createTransaction().insertRecordGroup(r.getDatabase().getDatabaseName(), r.getInsertData(), r.getDatabase()), r.getListener());
        }
        catch (BabuDBException e) {
            r.getListener().failed(e);
        }
    }

    private void doLookup(LSMDBRequest<byte[]> r) {
        LSMDatabase db = r.getDatabase();
        int numIndices = db.getIndexCount();
        if (r.getIndexId() >= numIndices || r.getIndexId() < 0) {
            r.getListener().failed(new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + r.getIndexId() + " does not exist"));
        } else {
            r.getListener().finished(db.getIndex(r.getIndexId()).lookup(r.getLookupKey()));
        }
    }

    private void doPrefixLookup(LSMDBRequest<Iterator<Map.Entry<byte[], byte[]>>> r) {
        LSMDatabase db = r.getDatabase();
        int numIndices = db.getIndexCount();
        if (r.getIndexId() >= numIndices || r.getIndexId() < 0) {
            r.getListener().failed(new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + r.getIndexId() + " does not exist"));
        } else {
            r.getListener().finished(db.getIndex(r.getIndexId()).prefixLookup(r.getLookupKey()));
        }
    }

    private void doRangeLookup(LSMDBRequest<Iterator<Map.Entry<byte[], byte[]>>> r) {
        LSMDatabase db = r.getDatabase();
        int numIndices = db.getIndexCount();
        if (r.getIndexId() >= numIndices || r.getIndexId() < 0) {
            r.getListener().failed(new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + r.getIndexId() + " does not exist"));
        } else {
            r.getListener().finished(db.getIndex(r.getIndexId()).rangeLookup(r.getFrom(), r.getTo()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLock(LSMDBRequest<Object> r) {
        AtomicBoolean atomicBoolean = this.locked;
        synchronized (atomicBoolean) {
            r.getListener().finished(this.locked);
            try {
                if (this.locked.get()) {
                    this.locked.wait();
                }
            }
            catch (InterruptedException e) {
                r.getListener().failed(new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, e.getMessage(), e));
            }
        }
    }

    public static enum RequestOperation {
        INSERT,
        LOOKUP,
        PREFIX_LOOKUP,
        RANGE_LOOKUP,
        USER_DEFINED_LOOKUP,
        LOCK;

    }
}

