/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.lsmdb;

public class LSN
implements Comparable<LSN> {
    private final int viewId;
    private final long sequenceNo;

    public LSN(int viewId, long sequenceNo) {
        this.viewId = viewId;
        this.sequenceNo = sequenceNo;
    }

    public LSN(byte[] lsn) throws NumberFormatException {
        this(new String(lsn));
    }

    public LSN(String representation) throws NumberFormatException {
        String[] rep = representation.split(":");
        if (rep.length != 2) {
            throw new NumberFormatException(representation + " is not a legal LSN string-representation.");
        }
        this.viewId = Integer.parseInt(rep[0]);
        this.sequenceNo = Long.valueOf(rep[1]);
    }

    public int getViewId() {
        return this.viewId;
    }

    public long getSequenceNo() {
        return this.sequenceNo;
    }

    @Override
    public int compareTo(LSN o) {
        if (this.viewId > o.viewId) {
            return 1;
        }
        if (this.viewId < o.viewId) {
            return -1;
        }
        if (this.sequenceNo > o.sequenceNo) {
            return 1;
        }
        if (this.sequenceNo < o.sequenceNo) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LSN) {
            return ((LSN)obj).viewId == this.viewId && ((LSN)obj).sequenceNo == this.sequenceNo;
        }
        return false;
    }

    public String toString() {
        return this.viewId + ":" + this.sequenceNo;
    }
}

