/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.plugin;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.plugin.PluginMain;
import org.xtreemfs.babudb.config.PluginConfig;
import org.xtreemfs.foundation.logging.Logging;

public final class PluginLoader
extends ClassLoader {
    private final Map<String, byte[]> clazzes = new HashMap<String, byte[]>();
    private BabuDBInternal babuDB;

    private PluginLoader(BabuDBInternal dbs) throws IOException {
        this.babuDB = dbs;
        for (String configPath : dbs.getConfig().getPlugins()) {
            String main = null;
            PluginConfig c = new PluginConfig(configPath);
            String pluginPath = c.getPluginLibraryPath();
            try {
                main = this.loadJar(pluginPath, "Main");
                if (main == null) {
                    throw new Exception("main class (extending PluginMain) not found!");
                }
                PluginMain m = (PluginMain)this.loadClass(main).newInstance();
                for (String depPath : m.getDependencies(configPath)) {
                    Logging.logMessage((int)6, (Object)this, (String)"Loading plugin dependency %s.", (Object[])new Object[]{depPath});
                    this.loadJar(depPath);
                }
                this.babuDB = m.execute(this.babuDB, configPath);
            }
            catch (Exception e) {
                if (e.getMessage() == null) {
                    Logging.logError((int)4, (Object)this, (Throwable)e);
                }
                throw new IOException("Plugin at '" + pluginPath + "' for version " + "0.5.6" + (configPath != null ? " with config at path " + configPath : "") + " could not be initialized, because " + e.getMessage() + "!", e.getCause());
            }
        }
    }

    private final void loadJar(String path) throws FileNotFoundException, IOException {
        this.loadJar(path, null);
    }

    private final String loadJar(String path, String classToSearchFor) throws FileNotFoundException, IOException {
        JarInputStream jis = new JarInputStream(new FileInputStream(path));
        JarEntry next = null;
        String main = null;
        while ((next = jis.getNextJarEntry()) != null) {
            if (!next.getName().endsWith(".class")) continue;
            byte[] buf = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int len = -1;
            while ((len = jis.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            String className = next.getName().substring(0, next.getName().length() - ".class".length()).replace('/', '.');
            if (classToSearchFor != null && className.endsWith(classToSearchFor)) {
                assert (main == null);
                main = className;
            }
            if (!this.clazzes.containsKey(className)) {
                this.clazzes.put(className, out.toByteArray());
            } else {
                Logging.logMessage((int)7, (Object)this, (String)"Did not load %s from %s, because it already exists.", (Object[])new Object[]{className, path});
            }
            out.close();
        }
        jis.close();
        return main;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            byte[] classBytes = this.clazzes.get(name);
            clazz = classBytes != null ? this.defineClass(name, classBytes, 0, classBytes.length) : this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public static final BabuDBInternal init(BabuDBInternal babuDB) throws IOException {
        PluginLoader loader = new PluginLoader(babuDB);
        return loader.babuDB;
    }
}

