/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.snapshots;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.xtreemfs.babudb.index.DefaultByteRangeComparator;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;

public class DefaultSnapshotConfig
implements SnapshotConfig {
    private static final long serialVersionUID = -4976962150947558070L;
    private int[] indices;
    private String name;
    private byte[][][] prefixes;
    private byte[][][] excludedPrefixes;
    private transient Map<Integer, Integer> indexMap;

    public DefaultSnapshotConfig(String snapName, int[] indices, byte[][][] prefixes, byte[][][] excludedPrefixes) {
        this.indices = indices;
        this.name = snapName;
        this.prefixes = this.removeCoveringPrefixes(prefixes);
        this.excludedPrefixes = excludedPrefixes;
        if (excludedPrefixes != null) {
            for (byte[][] keys : excludedPrefixes) {
                if (keys == null) continue;
                Arrays.sort(keys, DefaultByteRangeComparator.getInstance());
            }
        }
        this.initIndexMap();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int[] getIndices() {
        return this.indices;
    }

    @Override
    public byte[][] getPrefixes(int index) {
        if (this.indexMap == null) {
            this.initIndexMap();
        }
        return this.prefixes == null ? (byte[][])null : this.prefixes[this.indexMap.get(index)];
    }

    @Override
    public boolean containsKey(int index, byte[] key) {
        if (this.excludedPrefixes == null) {
            return true;
        }
        if (this.indexMap == null) {
            this.initIndexMap();
        }
        if (this.excludedPrefixes[this.indexMap.get(index)] == null) {
            return true;
        }
        byte[][] excl = this.excludedPrefixes[this.indexMap.get(index)];
        int i = DefaultSnapshotConfig.binarySearch(key, excl);
        return i == -1;
    }

    private static int binarySearch(byte[] key, byte[][] prefixes) {
        int high;
        int low = 0;
        int mid = high = prefixes.length - 1;
        int cmp = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            byte[] currPrefix = prefixes[mid];
            cmp = DefaultSnapshotConfig.startsWith(key, currPrefix);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static int startsWith(byte[] key, byte[] prefix) {
        for (int i = 0; i < key.length; ++i) {
            if (i >= prefix.length) {
                return 0;
            }
            if (key[i] < prefix[i]) {
                return -1;
            }
            if (key[i] <= prefix[i]) continue;
            return 1;
        }
        return key.length == prefix.length ? 0 : -1;
    }

    private byte[][][] removeCoveringPrefixes(byte[][][] prefixes) {
        if (prefixes == null) {
            return null;
        }
        byte[][][] newPrefixes = new byte[prefixes.length][][];
        for (int i = 0; i < prefixes.length; ++i) {
            newPrefixes[i] = this.removeCoveringPrefixes(prefixes[i]);
        }
        return newPrefixes;
    }

    private byte[][] removeCoveringPrefixes(byte[][] prefixes) {
        if (prefixes == null) {
            return null;
        }
        HashSet<Integer> covered = new HashSet<Integer>();
        for (int i = 0; i < prefixes.length; ++i) {
            for (int j = i + 1; j < prefixes.length; ++j) {
                if (this.covers(prefixes[j], prefixes[i])) {
                    covered.add(i);
                    continue;
                }
                if (!this.covers(prefixes[i], prefixes[j])) continue;
                covered.add(j);
            }
        }
        int count = 0;
        byte[][] newPrefixes = new byte[prefixes.length - covered.size()][];
        for (int i = 0; i < prefixes.length; ++i) {
            if (covered.contains(i)) continue;
            newPrefixes[count++] = prefixes[i];
        }
        return newPrefixes;
    }

    private boolean covers(byte[] prefix1, byte[] prefix2) {
        if (prefix1.length > prefix2.length) {
            return false;
        }
        for (int i = 0; i < prefix1.length; ++i) {
            if (prefix1[i] == prefix2[i]) continue;
            return false;
        }
        return true;
    }

    private void initIndexMap() {
        this.indexMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.indices.length; ++i) {
            this.indexMap.put(this.indices[i], i);
        }
    }
}

