/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.snapshots;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.api.index.ByteRangeComparator;
import org.xtreemfs.babudb.index.reader.DiskIndex;
import org.xtreemfs.babudb.snapshots.BabuDBView;

public class DiskIndexView
implements BabuDBView {
    private Map<Integer, DiskIndex> indexMap;

    public DiskIndexView(String dir, ByteRangeComparator[] comps, boolean compressed, boolean mmaped) throws BabuDBException {
        try {
            String[] files;
            this.indexMap = new HashMap<Integer, DiskIndex>();
            File dirAsFile = new File(dir);
            for (String file : files = dirAsFile.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".idx");
                }
            })) {
                int index = Integer.parseInt(file.substring(file.indexOf("IX") + 2, file.indexOf(86)));
                this.indexMap.put(index, new DiskIndex(dir + "/" + file, comps[index], compressed, mmaped));
            }
        }
        catch (IOException exc) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "could not load index file", exc);
        }
    }

    @Override
    public byte[] directLookup(int indexId, byte[] key) throws BabuDBException {
        DiskIndex index = this.indexMap.get(indexId);
        if (index == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + indexId + " does not exist");
        }
        return index.lookup(key);
    }

    @Override
    public ResultSet<byte[], byte[]> directPrefixLookup(int indexId, byte[] key, boolean ascending) throws BabuDBException {
        DiskIndex index = this.indexMap.get(indexId);
        if (index == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + indexId + " does not exist");
        }
        byte[][] range = index.getComparator().prefixToRange(key, true);
        return index.rangeLookup(range[0], range[1], ascending);
    }

    @Override
    public ResultSet<byte[], byte[]> directRangeLookup(int indexId, byte[] from, byte[] to, boolean ascending) throws BabuDBException {
        DiskIndex index = this.indexMap.get(indexId);
        if (index == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + indexId + " does not exist");
        }
        return index.rangeLookup(from, to, ascending);
    }

    @Override
    public void shutdown() throws BabuDBException {
        try {
            for (DiskIndex index : this.indexMap.values()) {
                index.destroy();
            }
        }
        catch (IOException exc) {
            throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "", exc);
        }
    }
}

