/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.snapshots;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.snapshots.BabuDBView;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;

public class InMemoryView
implements BabuDBView {
    private DatabaseInternal db;
    private Map<Integer, Integer> snapIDMap;
    private SnapshotConfig snap;

    public InMemoryView(BabuDBInternal babuDB, String dbName, SnapshotConfig snap, int[] snapIDs) throws BabuDBException {
        this.db = babuDB.getDatabaseManager().getDatabase(dbName);
        this.snap = snap;
        this.snapIDMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < snap.getIndices().length; ++i) {
            this.snapIDMap.put(snap.getIndices()[i], snapIDs[i]);
        }
    }

    @Override
    public byte[] directLookup(int indexId, byte[] key) throws BabuDBException {
        Integer snapId = this.snapIDMap.get(indexId);
        if (snapId == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + indexId + " does not exist");
        }
        return this.isCovered(indexId, key) && this.snap.containsKey(indexId, key) ? this.db.directLookup(indexId, snapId, key) : null;
    }

    @Override
    public ResultSet<byte[], byte[]> directPrefixLookup(final int indexId, final byte[] key, final boolean ascending) throws BabuDBException {
        final Integer snapId = this.snapIDMap.get(indexId);
        if (snapId == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + indexId + " does not exist");
        }
        return new ResultSet<byte[], byte[]>(){
            private ResultSet<byte[], byte[]> it;
            private Map.Entry<byte[], byte[]> next;
            {
                this.it = InMemoryView.this.db.directPrefixLookup(indexId, snapId, key, ascending);
                this.getNextEntry();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Map.Entry<byte[], byte[]> tmp = this.next;
                this.getNextEntry();
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void getNextEntry() {
                while (this.it.hasNext()) {
                    this.next = (Map.Entry)this.it.next();
                    if (!InMemoryView.this.isCovered(indexId, this.next.getKey()) || !InMemoryView.this.snap.containsKey(indexId, this.next.getKey())) continue;
                    return;
                }
                this.next = null;
            }

            @Override
            public void free() {
                this.it.free();
            }
        };
    }

    @Override
    public ResultSet<byte[], byte[]> directRangeLookup(final int indexId, final byte[] from, final byte[] to, final boolean ascending) throws BabuDBException {
        final Integer snapId = this.snapIDMap.get(indexId);
        if (snapId == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_INDEX, "index " + indexId + " does not exist");
        }
        return new ResultSet<byte[], byte[]>(){
            private ResultSet<byte[], byte[]> it;
            private Map.Entry<byte[], byte[]> next;
            {
                this.it = InMemoryView.this.db.directRangeLookup(indexId, snapId, from, to, ascending);
                this.getNextEntry();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Map.Entry<byte[], byte[]> tmp = this.next;
                this.getNextEntry();
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void getNextEntry() {
                while (this.it.hasNext()) {
                    this.next = (Map.Entry)this.it.next();
                    if (!InMemoryView.this.isCovered(indexId, this.next.getKey()) || !InMemoryView.this.snap.containsKey(indexId, this.next.getKey())) continue;
                    return;
                }
                this.next = null;
            }

            @Override
            public void free() {
                this.it.free();
            }
        };
    }

    @Override
    public void shutdown() throws BabuDBException {
    }

    private boolean isCovered(int index, byte[] key) {
        if (this.snap.getPrefixes(index) == null) {
            return true;
        }
        for (byte[] prefix : this.snap.getPrefixes(index)) {
            if (!InMemoryView.startsWith(key, prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(byte[] key, byte[] prefix) {
        if (key.length >= prefix.length) {
            for (int i = 0; i < prefix.length; ++i) {
                if (key[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

