/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.snapshots;

import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseRO;
import org.xtreemfs.babudb.api.database.DatabaseRequestResult;
import org.xtreemfs.babudb.api.database.ResultSet;
import org.xtreemfs.babudb.api.database.UserDefinedLookup;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.snapshots.BabuDBView;

public class Snapshot
implements DatabaseRO {
    private final BabuDBInternal dbs;
    private BabuDBView view;

    public Snapshot(BabuDBView view, BabuDBInternal dbs) {
        this.view = view;
        this.dbs = dbs;
    }

    public synchronized BabuDBView getView() {
        return this.view;
    }

    public synchronized void setView(BabuDBView view) {
        this.view = view;
    }

    @Override
    public void shutdown() throws BabuDBException {
        this.view.shutdown();
    }

    @Override
    public DatabaseRequestResult<byte[]> lookup(int indexId, byte[] key, Object context) {
        BabuDBRequestResultImpl<byte[]> result = new BabuDBRequestResultImpl<byte[]>(context, this.dbs.getResponseManager());
        try {
            byte[] r = this.view.directLookup(indexId, key);
            result.finished(r);
        }
        catch (BabuDBException e) {
            result.failed(e);
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> prefixLookup(int indexId, byte[] key, Object context) {
        BabuDBRequestResultImpl<ResultSet<byte[], byte[]>> result = new BabuDBRequestResultImpl<ResultSet<byte[], byte[]>>(context, this.dbs.getResponseManager());
        try {
            ResultSet<byte[], byte[]> r = this.view.directPrefixLookup(indexId, key, true);
            result.finished(r);
        }
        catch (BabuDBException e) {
            result.failed(e);
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reversePrefixLookup(int indexId, byte[] key, Object context) {
        BabuDBRequestResultImpl<ResultSet<byte[], byte[]>> result = new BabuDBRequestResultImpl<ResultSet<byte[], byte[]>>(context, this.dbs.getResponseManager());
        try {
            ResultSet<byte[], byte[]> r = this.view.directPrefixLookup(indexId, key, false);
            result.finished(r);
        }
        catch (BabuDBException e) {
            result.failed(e);
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> rangeLookup(int indexId, byte[] from, byte[] to, Object context) {
        BabuDBRequestResultImpl<ResultSet<byte[], byte[]>> result = new BabuDBRequestResultImpl<ResultSet<byte[], byte[]>>(context, this.dbs.getResponseManager());
        try {
            ResultSet<byte[], byte[]> r = this.view.directRangeLookup(indexId, from, to, true);
            result.finished(r);
        }
        catch (BabuDBException e) {
            result.failed(e);
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<ResultSet<byte[], byte[]>> reverseRangeLookup(int indexId, byte[] from, byte[] to, Object context) {
        BabuDBRequestResultImpl<ResultSet<byte[], byte[]>> result = new BabuDBRequestResultImpl<ResultSet<byte[], byte[]>>(context, this.dbs.getResponseManager());
        try {
            ResultSet<byte[], byte[]> r = this.view.directRangeLookup(indexId, from, to, false);
            result.finished(r);
        }
        catch (BabuDBException e) {
            result.failed(e);
        }
        return result;
    }

    @Override
    public DatabaseRequestResult<Object> userDefinedLookup(UserDefinedLookup udl, Object context) {
        throw new UnsupportedOperationException();
    }
}

