/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.snapshots;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xtreemfs.babudb.BabuDBRequestResultImpl;
import org.xtreemfs.babudb.api.database.DatabaseRO;
import org.xtreemfs.babudb.api.dev.BabuDBInternal;
import org.xtreemfs.babudb.api.dev.DatabaseInternal;
import org.xtreemfs.babudb.api.dev.SnapshotManagerInternal;
import org.xtreemfs.babudb.api.dev.transaction.InMemoryProcessing;
import org.xtreemfs.babudb.api.dev.transaction.OperationInternal;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.lsmdb.BabuDBTransaction;
import org.xtreemfs.babudb.snapshots.DiskIndexView;
import org.xtreemfs.babudb.snapshots.InMemoryView;
import org.xtreemfs.babudb.snapshots.Snapshot;
import org.xtreemfs.babudb.snapshots.SnapshotConfig;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.FSUtils;

public class SnapshotManagerImpl
implements SnapshotManagerInternal {
    public static final String SNAP_DIR = "snapshots";
    private final BabuDBInternal dbs;
    private final Map<String, Map<String, Snapshot>> snapshotDBs;

    public SnapshotManagerImpl(BabuDBInternal dbs) {
        this.dbs = dbs;
        this.snapshotDBs = Collections.synchronizedMap(new HashMap());
        this.initializeTransactionManager();
    }

    @Override
    public void init() throws BabuDBException {
        for (Map.Entry<String, DatabaseInternal> entry : this.dbs.getDatabaseManager().getDatabasesInternal().entrySet()) {
            String[] snapshots;
            File snapDir = new File(this.dbs.getConfig().getBaseDir(), entry.getKey() + "/snapshots");
            if (!snapDir.exists()) continue;
            HashMap<String, Snapshot> snapMap = new HashMap<String, Snapshot>();
            this.snapshotDBs.put(entry.getKey(), snapMap);
            boolean compressed = entry.getValue().getLSMDB().getIndex(0).isCompressed();
            boolean mmaped = entry.getValue().getLSMDB().getIndex(0).isMMapEnabled();
            for (String snapName : snapshots = snapDir.list()) {
                DiskIndexView view = new DiskIndexView(snapDir + "/" + snapName, entry.getValue().getComparators(), compressed, mmaped);
                snapMap.put(snapName, new Snapshot(view, this.dbs));
            }
        }
    }

    @Override
    public void shutdown() throws BabuDBException {
        for (Map<String, Snapshot> snapshots : this.snapshotDBs.values()) {
            for (Snapshot snapshot : snapshots.values()) {
                snapshot.shutdown();
            }
        }
        Logging.logMessage((int)7, (Object)this, (String)"snapshot manager shut down successfully", (Object[])new Object[0]);
    }

    @Override
    public DatabaseRO getSnapshotDB(String dbName, String snapshotName) throws BabuDBException {
        Map<String, Snapshot> snapMap = this.snapshotDBs.get(dbName);
        if (snapMap == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT, "no snapshots exist for database '" + dbName + "'");
        }
        Snapshot snap = snapMap.get(snapshotName);
        if (snap == null) {
            throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT, "no snapshot '" + snapshotName + "' exists for database '" + dbName + "'");
        }
        return snap;
    }

    @Override
    public void createPersistentSnapshot(String dbName, SnapshotConfig snap) throws BabuDBException {
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(this.dbs.getResponseManager());
        this.dbs.getTransactionManager().makePersistent(this.dbs.getDatabaseManager().createTransaction().createSnapshot(dbName, snap), result);
        result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshotComplete(String dbName, SnapshotConfig snap) throws BabuDBException {
        Map<String, Map<String, Snapshot>> map = this.snapshotDBs;
        synchronized (map) {
            DatabaseInternal db = this.dbs.getDatabaseManager().getDatabase(dbName);
            boolean compressed = db.getLSMDB().getIndex(0).isCompressed();
            boolean mmaped = db.getLSMDB().getIndex(0).isMMapEnabled();
            Snapshot s = this.snapshotDBs.get(dbName).get(snap.getName());
            s.setView(new DiskIndexView(this.getSnapshotDir(dbName, snap.getName()), this.dbs.getDatabaseManager().getDatabase(dbName).getComparators(), compressed, mmaped));
        }
    }

    @Override
    public void deletePersistentSnapshot(String dbName, String snapshotName) throws BabuDBException {
        BabuDBRequestResultImpl<Object> result = new BabuDBRequestResultImpl<Object>(this.dbs.getResponseManager());
        this.dbs.getTransactionManager().makePersistent(this.dbs.getDatabaseManager().createTransaction().deleteSnapshot(dbName, snapshotName), result);
        result.get();
    }

    @Override
    public String[] getAllSnapshots(String dbName) {
        Map<String, Snapshot> snapMap = this.snapshotDBs.get(dbName);
        if (snapMap != null) {
            Set<String> names = snapMap.keySet();
            return names.toArray(new String[names.size()]);
        }
        return new String[0];
    }

    @Override
    public void deleteAllSnapshots(String dbName) throws BabuDBException {
        Map<String, Snapshot> snapMap = this.snapshotDBs.get(dbName);
        if (snapMap != null) {
            for (Map.Entry<String, Snapshot> snap : snapMap.entrySet()) {
                snap.getValue().shutdown();
                this.dbs.getCheckpointer().removeSnapshotMaterializationRequest(dbName, snap.getKey());
            }
            this.snapshotDBs.remove(dbName);
        }
        FSUtils.delTree((File)new File(this.getSnapshotDir(dbName, null)));
    }

    @Override
    public String getSnapshotDir(String dbName, String snapshotName) {
        return this.dbs.getConfig().getBaseDir() + dbName + "/" + SNAP_DIR + "/" + (snapshotName == null ? "" : snapshotName);
    }

    private void initializeTransactionManager() {
        this.dbs.getTransactionManager().registerInMemoryProcessing((byte)1, new InMemoryProcessing(){

            @Override
            public Object[] deserializeRequest(ReusableBuffer serialized) throws BabuDBException {
                ObjectInputStream oin = null;
                try {
                    oin = new ObjectInputStream(new ByteArrayInputStream(serialized.array()));
                    int dbId = oin.readInt();
                    SnapshotConfig snap = (SnapshotConfig)oin.readObject();
                    Object[] objectArray = new Object[]{dbId, snap};
                    return objectArray;
                }
                catch (Exception e) {
                    throw new BabuDBException(BabuDBException.ErrorCode.IO_ERROR, "Could not deserialize operation of type 1, because: " + e.getMessage(), e);
                }
                finally {
                    try {
                        serialized.flip();
                        if (oin != null) {
                            oin.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
            }

            @Override
            public OperationInternal convertToOperation(Object[] args) {
                return new BabuDBTransaction.BabuDBOperation(1, null, new Object[]{args[0], args[1]});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object process(OperationInternal operation) throws BabuDBException {
                Object[] args = operation.getParams();
                int dbId = (Integer)args[0];
                SnapshotConfig snap = (SnapshotConfig)args[1];
                if (dbId == -1 && operation.getDatabaseName() != null) {
                    dbId = SnapshotManagerImpl.this.dbs.getDatabaseManager().getDatabase(operation.getDatabaseName()).getLSMDB().getDatabaseId();
                    operation.updateParams(new Object[]{dbId, snap});
                } else if (operation.getDatabaseName() == null) {
                    operation.updateDatabaseName(SnapshotManagerImpl.this.dbs.getDatabaseManager().getDatabase(dbId).getName());
                }
                HashMap<String, Snapshot> snapMap = (HashMap<String, Snapshot>)SnapshotManagerImpl.this.snapshotDBs.get(operation.getDatabaseName());
                if (snapMap == null) {
                    snapMap = new HashMap<String, Snapshot>();
                    SnapshotManagerImpl.this.snapshotDBs.put(operation.getDatabaseName(), snapMap);
                }
                if (snapMap.containsKey(snap.getName())) {
                    throw new BabuDBException(BabuDBException.ErrorCode.SNAP_EXISTS, "snapshot '" + snap.getName() + "' already exists");
                }
                snapMap.put(snap.getName(), new Snapshot(null, SnapshotManagerImpl.this.dbs));
                int[] snapIds = null;
                try {
                    SnapshotManagerImpl.this.dbs.getTransactionManager().lockService();
                    snapIds = SnapshotManagerImpl.this.dbs.getDatabaseManager().getDatabase(dbId).getLSMDB().createSnapshot(snap.getIndices());
                }
                catch (InterruptedException e) {
                    throw new BabuDBException(BabuDBException.ErrorCode.INTERRUPTED, e.getMessage());
                }
                finally {
                    SnapshotManagerImpl.this.dbs.getTransactionManager().unlockService();
                }
                SnapshotManagerImpl.this.dbs.getCheckpointer().addSnapshotMaterializationRequest(operation.getDatabaseName(), snapIds, snap);
                Map map = SnapshotManagerImpl.this.snapshotDBs;
                synchronized (map) {
                    Snapshot s = (Snapshot)snapMap.get(snap.getName());
                    if (s.getView() == null) {
                        s.setView(new InMemoryView(SnapshotManagerImpl.this.dbs, operation.getDatabaseName(), snap, snapIds));
                    }
                }
                return null;
            }
        });
        this.dbs.getTransactionManager().registerInMemoryProcessing((byte)5, new InMemoryProcessing(){

            @Override
            public Object[] deserializeRequest(ReusableBuffer serialized) throws BabuDBException {
                byte[] payload = serialized.array();
                byte offs = payload[0];
                String dbName = new String(payload, 1, (int)offs);
                String snapName = new String(payload, offs + 1, payload.length - offs - 1);
                serialized.flip();
                return new Object[]{dbName, snapName};
            }

            @Override
            public OperationInternal convertToOperation(Object[] args) {
                return new BabuDBTransaction.BabuDBOperation(5, (String)args[0], new Object[]{args[1]});
            }

            @Override
            public Object process(OperationInternal operation) throws BabuDBException {
                String snapshotName = (String)operation.getParams()[0];
                Map snapMap = (Map)SnapshotManagerImpl.this.snapshotDBs.get(operation.getDatabaseName());
                if (snapMap == null) {
                    throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT, "snapshot '" + snapshotName + "' does not exist");
                }
                Snapshot snap = (Snapshot)snapMap.get(snapshotName);
                if (snap == null) {
                    throw new BabuDBException(BabuDBException.ErrorCode.NO_SUCH_SNAPSHOT, "snapshot '" + snapshotName + "' does not exist");
                }
                snap.getView().shutdown();
                snapMap.remove(snapshotName);
                SnapshotManagerImpl.this.dbs.getCheckpointer().removeSnapshotMaterializationRequest(operation.getDatabaseName(), snapshotName);
                FSUtils.delTree((File)new File(SnapshotManagerImpl.this.getSnapshotDir(operation.getDatabaseName(), snapshotName)));
                return null;
            }
        });
    }
}

