/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.babudb.tools;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.xtreemfs.babudb.BabuDBFactory;
import org.xtreemfs.babudb.api.BabuDB;
import org.xtreemfs.babudb.api.database.Database;
import org.xtreemfs.babudb.api.exception.BabuDBException;
import org.xtreemfs.babudb.config.ConfigBuilder;
import org.xtreemfs.foundation.util.OutputUtils;

public class DBDumpTool {
    public static void dumpDB(String dbDir, String logDir, boolean compression, RecordFormatter formatter, PrintStream out) throws BabuDBException {
        BabuDB databaseSystem = BabuDBFactory.createBabuDB(new ConfigBuilder().setDataPath(dbDir, logDir).setCompressed(compression).build());
        out.println("<BabuDB version=\"0.5.6\">");
        Map<String, Database> dbs = databaseSystem.getDatabaseManager().getDatabases();
        long entryCount = 0L;
        for (Map.Entry<String, Database> entry : dbs.entrySet()) {
            Database db = entry.getValue();
            out.println("\t<database name=\"" + db.getName() + "\">");
            int numIndices = db.getComparators().length;
            for (int i = 0; i < numIndices; ++i) {
                out.println("\t\t<index number=\"" + i + "\">");
                Iterator it = db.prefixLookup(i, new byte[0], null).get();
                while (it.hasNext()) {
                    Map.Entry next = (Map.Entry)it.next();
                    out.println("\t\t\t<key>");
                    out.println("\t\t\t\t" + formatter.formatKey((byte[])next.getKey(), db.getName(), i));
                    out.println("\t\t\t</key>");
                    out.println("\t\t\t<value>");
                    out.println("\t\t\t\t" + formatter.formatValue((byte[])next.getValue(), (byte[])next.getKey(), db.getName(), i));
                    out.println("\t\t\t</value>");
                    ++entryCount;
                }
                out.println("\t\t</index>");
            }
            out.println("\t</database>");
        }
        out.println("</BabuDB>");
        databaseSystem.shutdown();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            System.out.println("usage: " + DBDumpTool.class.getSimpleName() + " <DB directory> <DB log directory> [dump file]");
            return;
        }
        String dbDir = args[0];
        String logDir = args[1];
        PrintStream out = args.length == 3 ? new PrintStream(args[2]) : System.out;
        RecordFormatter formatter = new RecordFormatter(){

            @Override
            public String formatValue(byte[] value, byte[] key, String databaseName, int indexId) {
                return OutputUtils.byteArrayToHexString((byte[])value);
            }

            @Override
            public String formatKey(byte[] key, String databaseName, int indexId) {
                return OutputUtils.byteArrayToHexString((byte[])key);
            }
        };
        DBDumpTool.dumpDB(dbDir, logDir, false, formatter, out);
    }

    public static interface RecordFormatter {
        public String formatKey(byte[] var1, String var2, int var3);

        public String formatValue(byte[] var1, byte[] var2, String var3, int var4);
    }
}

