/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class Capability {
    private GlobalTypes.XCap xcap;
    private final String sharedSecret;

    public Capability(String fileId, int accessMode, int validity, long expires, String clientIdentity, int epochNo, boolean replicateOnClose, GlobalTypes.SnapConfig snapConfig, long snapTimestamp, String sharedSecret) {
        this.sharedSecret = sharedSecret;
        GlobalTypes.XCap.Builder builder = GlobalTypes.XCap.newBuilder().setAccessMode(accessMode).setClientIdentity(clientIdentity).setExpireTimeS(expires).setExpireTimeoutS(validity).setFileId(fileId).setReplicateOnClose(replicateOnClose).setTruncateEpoch(epochNo).setSnapConfig(snapConfig).setSnapTimestamp(snapTimestamp);
        String sig = this.calcSignature(builder);
        builder.setServerSignature(sig);
        this.xcap = builder.build();
    }

    public Capability(GlobalTypes.XCap xcap, String sharedSecret) {
        this.xcap = xcap;
        this.sharedSecret = sharedSecret;
    }

    public GlobalTypes.XCap getXCap() {
        return this.xcap;
    }

    public String getFileId() {
        return this.xcap.getFileId();
    }

    public int getAccessMode() {
        return this.xcap.getAccessMode();
    }

    public long getExpires() {
        return this.xcap.getExpireTimeS();
    }

    public String getClientIdentity() {
        return this.xcap.getClientIdentity();
    }

    public int getEpochNo() {
        return this.xcap.getTruncateEpoch();
    }

    public String getSignature() {
        return this.xcap.getServerSignature();
    }

    public boolean isValid() {
        return !this.hasExpired() && this.hasValidSignature();
    }

    public boolean hasExpired() {
        return TimeSync.getGlobalTime() / 1000L > this.xcap.getExpireTimeS();
    }

    public boolean hasValidSignature() {
        return this.xcap.getServerSignature().equals(this.calcSignature(this.xcap.toBuilder()));
    }

    public boolean isReplicateOnClose() {
        return this.xcap.getReplicateOnClose();
    }

    public GlobalTypes.SnapConfig getSnapConfig() {
        return this.xcap.getSnapConfig();
    }

    public long getSnapTimestamp() {
        return this.xcap.getSnapTimestamp();
    }

    public String toString() {
        return this.xcap.toString();
    }

    protected String calcSignature(GlobalTypes.XCap.Builder builder) {
        String plainText = builder.getFileId() + Integer.toString(builder.getAccessMode()) + Long.toString(builder.getExpireTimeS()) + Long.toString(builder.getTruncateEpoch()) + Long.toString(builder.getSnapConfig().getNumber()) + Long.toString(builder.getSnapTimestamp()) + this.sharedSecret;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(plainText.getBytes());
            byte[] digest = md5.digest();
            return OutputUtils.byteArrayToHexString(digest);
        }
        catch (NoSuchAlgorithmException exc) {
            Logging.logError(3, this, exc);
            return null;
        }
    }
}

