/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.common.util.NetUtils;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class HeartbeatThread
extends LifeCycleThread {
    public static final long UPDATE_INTERVAL = 60000L;
    public static final long CONCURRENT_RETRY_INTERVAL = 5000L;
    private final ServiceUUID uuid;
    private final ServiceDataGenerator serviceDataGen;
    private final DIRClient client;
    private volatile boolean quit;
    private final ServiceConfig config;
    private final boolean advertiseUDPEndpoints;
    private final String proto;
    private String advertisedHostName;
    private final RPC.UserCredentials uc;
    private static final String STATIC_ATTR_PREFIX = "static.";
    public static final String STATUS_ATTR = "static.status";
    public static final String DO_NOT_SET_LAST_UPDATED = "static.do_not_set_last_updated";
    private long lastHeartbeat;
    private final Object pauseLock;
    private int pauseNumberOfWaitingThreads;
    private boolean paused;
    private static RPC.Auth authNone = RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_NONE).build();
    private volatile boolean addressMappingRenewalPending = false;
    private volatile boolean addressMappingRenewalTriggered = false;
    private Object updateIntervalMonitor = new Object();

    public HeartbeatThread(String name, DIRClient client, ServiceUUID uuid, ServiceDataGenerator serviceDataGen, ServiceConfig config, boolean advertiseUDPEndpoints) {
        super(name);
        this.setPriority(10);
        this.pauseLock = new Object();
        this.client = client;
        this.uuid = uuid;
        this.serviceDataGen = serviceDataGen;
        this.config = config;
        this.advertiseUDPEndpoints = advertiseUDPEndpoints;
        this.uc = RPC.UserCredentials.newBuilder().setUsername("hb-thread").addGroups("xtreemfs-services").build();
        this.proto = !config.isUsingSSL() ? "pbrpc" : (config.isGRIDSSLmode() ? "pbrpcg" : "pbrpcs");
        if (config.isUsingMultihoming() && config.isUsingRenewalSignal()) {
            this.enableAddressMappingRenewalSignal();
        }
        this.lastHeartbeat = TimeSync.getGlobalTime();
    }

    @Override
    public void shutdown() {
        try {
            if (this.client.clientIsAlive()) {
                this.client.xtreemfs_service_offline(null, authNone, this.uc, this.uuid.toString(), 1);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(4, this, "could not set service offline at DIR", new Object[0]);
            Logging.logError(4, this, ex);
        }
        this.quit = true;
        this.interrupt();
    }

    public void initialize() throws IOException {
        try {
            while (true) {
                try {
                    this.registerServices(-1);
                }
                catch (PBRPCException ex) {
                    if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_EAGAIN) {
                        if (!Logging.isInfo()) continue;
                        Logging.logMessage(6, Logging.Category.misc, this, "concurrent service registration; will try again after %d milliseconds", 5000L);
                        continue;
                    }
                    throw ex;
                }
                break;
            }
            this.registerAddressMappings();
        }
        catch (InterruptedException ex) {
        }
        catch (Exception ex) {
            Logging.logMessage(3, this, "an error occurred while initially contacting the Directory Service: " + ex, new Object[0]);
            throw new IOException("cannot initialize service at XtreemFS DIR: " + ex, ex);
        }
        try {
            this.setServiceConfiguration();
        }
        catch (Exception e) {
            Logging.logMessage(3, this, "An error occurred while submitting the service configuration to the DIR service:", new Object[0]);
            Logging.logError(3, this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.notifyStarted();
            while (!this.quit) {
                block23: {
                    Object object = this.pauseLock;
                    synchronized (object) {
                        while (this.pauseNumberOfWaitingThreads > 0) {
                            this.pauseLock.wait();
                        }
                        this.paused = false;
                    }
                    try {
                        this.registerServices(1);
                    }
                    catch (PBRPCException ex) {
                        if (ex.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_EAGAIN) {
                            if (Logging.isInfo()) {
                                Logging.logMessage(6, Logging.Category.misc, this, "concurrent service registration; will try again after %d milliseconds", 60000L);
                            }
                        } else {
                            Logging.logMessage(3, this, "An error occurred during the periodic registration at the DIR:", new Object[0]);
                        }
                        Logging.logError(3, this, ex);
                    }
                    catch (IOException ex) {
                        Logging.logMessage(3, this, "periodic registration at DIR failed: %s", ex.toString());
                        if (!Logging.isDebug()) break block23;
                        Logging.logError(7, this, ex);
                    }
                }
                if (this.addressMappingRenewalPending) {
                    try {
                        this.addressMappingRenewalTriggered = false;
                        this.registerAddressMappings();
                        this.addressMappingRenewalPending = false;
                        UUIDResolver.renewNetworks();
                    }
                    catch (IOException ex) {
                        Logging.logMessage(3, this, "requested renewal of address mappings failed: %s", ex.toString());
                    }
                }
                if (this.quit) break;
                Object ex = this.pauseLock;
                synchronized (ex) {
                    this.paused = true;
                    this.pauseLock.notifyAll();
                }
                if (this.addressMappingRenewalTriggered) continue;
                ex = this.updateIntervalMonitor;
                synchronized (ex) {
                    this.updateIntervalMonitor.wait(60000L);
                }
            }
            this.notifyStopped();
        }
        catch (InterruptedException e) {
            this.notifyStopped();
        }
        catch (Throwable ex) {
            this.notifyCrashed(ex);
        }
    }

    private void registerServices(int numRetries) throws IOException, PBRPCException, InterruptedException {
        for (DIR.Service reg : this.serviceDataGen.getServiceData().getServicesList()) {
            DIR.ServiceSet oldSet = numRetries == -1 ? this.client.xtreemfs_service_get_by_uuid(null, authNone, this.uc, reg.getUuid()) : this.client.xtreemfs_service_get_by_uuid(null, authNone, this.uc, reg.getUuid(), numRetries);
            long currentVersion = 0L;
            DIR.Service oldService = oldSet.getServicesCount() == 0 ? null : oldSet.getServices(0);
            HashMap<String, String> staticAttrs = new HashMap<String, String>();
            if (oldService != null) {
                currentVersion = oldService.getVersion();
                DIR.ServiceDataMap data = oldService.getData();
                for (GlobalTypes.KeyValuePair pair : data.getDataList()) {
                    if (!pair.getKey().startsWith(STATIC_ATTR_PREFIX)) continue;
                    staticAttrs.put(pair.getKey(), pair.getValue());
                }
            }
            if (!staticAttrs.containsKey(STATUS_ATTR)) {
                staticAttrs.put(STATUS_ATTR, Integer.toString(DIR.ServiceStatus.SERVICE_STATUS_AVAIL.getNumber()));
            }
            DIR.Service.Builder builder = reg.toBuilder();
            builder.setVersion(currentVersion);
            DIR.ServiceDataMap.Builder data = DIR.ServiceDataMap.newBuilder();
            for (Map.Entry sAttr : staticAttrs.entrySet()) {
                data.addData(GlobalTypes.KeyValuePair.newBuilder().setKey((String)sAttr.getKey()).setValue((String)sAttr.getValue()).build());
            }
            if (reg.getType() == DIR.ServiceType.SERVICE_TYPE_VOLUME && oldService != null && oldService.getUuid().equals(reg.getUuid())) {
                String mrcUUID = null;
                for (GlobalTypes.KeyValuePair kv : reg.getData().getDataList()) {
                    if (!kv.getKey().equals("mrc")) continue;
                    mrcUUID = kv.getValue();
                    break;
                }
                assert (mrcUUID != null);
                int maxMRCNo = 1;
                boolean contained = false;
                for (GlobalTypes.KeyValuePair kv : oldService.getData().getDataList()) {
                    int no;
                    if (!kv.getKey().startsWith("mrc")) continue;
                    data.addData(kv);
                    if (kv.getValue().equals(mrcUUID)) {
                        contained = true;
                    }
                    if (kv.getKey().equals("mrc") || (no = Integer.parseInt(kv.getKey().substring(3))) <= maxMRCNo) continue;
                    maxMRCNo = no;
                }
                if (!contained) {
                    data.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("mrc" + (maxMRCNo + 1)).setValue(mrcUUID));
                }
                for (GlobalTypes.KeyValuePair kv : reg.getData().getDataList()) {
                    if (kv.getKey().startsWith("mrc")) continue;
                    data.addData(kv);
                }
            } else {
                data.addAllData(reg.getData().getDataList());
            }
            builder.setData(data);
            if (numRetries == -1) {
                this.client.xtreemfs_service_register(null, authNone, this.uc, builder.build());
            } else {
                this.client.xtreemfs_service_register(null, authNone, this.uc, builder.build(), numRetries);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.misc, this, "%s successfully updated at Directory Service", this.uuid);
            }
            this.lastHeartbeat = TimeSync.getGlobalTime();
        }
    }

    private void setServiceConfiguration() throws IOException, PBRPCException, InterruptedException {
        DIR.Configuration conf = this.client.xtreemfs_configuration_get(null, authNone, this.uc, this.uuid.toString());
        long currentVersion = 0L;
        currentVersion = conf.getVersion();
        DIR.Configuration.Builder confBuilder = DIR.Configuration.newBuilder();
        confBuilder.setUuid(this.uuid.toString()).setVersion(currentVersion);
        for (Map.Entry<String, String> mapEntry : this.config.toHashMap().entrySet()) {
            confBuilder.addParameter(GlobalTypes.KeyValuePair.newBuilder().setKey(mapEntry.getKey()).setValue(mapEntry.getValue()).build());
        }
        this.client.xtreemfs_configuration_set(null, authNone, this.uc, confBuilder.build());
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "%s successfully send configuration to Directory Service", this.uuid);
        }
    }

    private void registerAddressMappings() throws InterruptedException, IOException {
        Object host;
        List<DIR.AddressMapping.Builder> reachableEndpoints = NetUtils.getReachableEndpoints(this.config.getPort(), this.proto);
        DIR.AddressMapping.Builder advertisedEndpoint = null;
        if (!this.config.getHostName().isEmpty() || this.config.getAddress() != null) {
            Object object = host = this.config.getHostName().isEmpty() ? this.config.getAddress().getHostName() : this.config.getHostName();
            if (((String)host).startsWith("/")) {
                host = ((String)host).substring(1);
            }
            try {
                InetAddress ia = InetAddress.getByName((String)host);
            }
            catch (Exception ex) {
                Logging.logMessage(4, this, "WARNING! Could not resolve my hostname (%s) locally! Please make sure that the hostname is set correctly (either on your system or in the service config file). This will lead to problems if clients and other OSDs cannot resolve this service's address!\n", host);
            }
            advertisedEndpoint = DIR.AddressMapping.newBuilder().setUuid(this.uuid.toString()).setVersion(0L).setProtocol(this.proto).setAddress((String)host).setPort(this.config.getPort()).setTtlS(3600).setUri(this.proto + "://" + (String)host + ":" + this.config.getPort());
        }
        if (advertisedEndpoint == null) {
            try {
                host = InetAddress.getLocalHost();
                String hostAddress = NetUtils.getHostAddress((InetAddress)host);
                for (DIR.AddressMapping.Builder mapping : reachableEndpoints) {
                    if (!mapping.getAddress().equals(hostAddress)) continue;
                    advertisedEndpoint = mapping;
                    break;
                }
            }
            catch (UnknownHostException e) {
                Logging.logMessage(4, Logging.Category.net, this, "Could not resolve the local hostname.", new Object[0]);
            }
        }
        if (advertisedEndpoint == null && reachableEndpoints.size() > 0) {
            advertisedEndpoint = reachableEndpoints.get(0);
        }
        if (advertisedEndpoint == null) {
            Logging.logMessage(4, Logging.Category.net, this, "Could not find a valid IP address, will use 127.0.0.1 instead.", new Object[0]);
            advertisedEndpoint = DIR.AddressMapping.newBuilder().setAddress("127.0.0.1").setPort(this.config.getPort()).setProtocol(this.proto).setTtlS(3600).setUri(NetUtils.getURI(this.proto, InetAddress.getByName("127.0.0.1"), this.config.getPort()));
        }
        long version = 0L;
        DIR.AddressMappingSet ams = this.client.xtreemfs_address_mappings_get(null, authNone, this.uc, this.uuid.toString());
        if (ams.getMappingsCount() > 0) {
            version = ams.getMappings(0).getVersion();
        }
        advertisedEndpoint.setVersion(version).setMatchNetwork("*").setUuid(this.uuid.toString());
        this.advertisedHostName = advertisedEndpoint.getAddress();
        ArrayList<DIR.AddressMapping.Builder> endpoints = new ArrayList<DIR.AddressMapping.Builder>();
        endpoints.add(advertisedEndpoint);
        if (this.advertiseUDPEndpoints) {
            endpoints.add(NetUtils.cloneMappingForProtocol(advertisedEndpoint, "pbrpcu"));
        }
        if (this.config.isUsingMultihoming()) {
            for (DIR.AddressMapping.Builder mapping : reachableEndpoints) {
                if (advertisedEndpoint.getAddress().equals(mapping.getAddress())) continue;
                mapping.setUuid(this.uuid.toString());
                endpoints.add(mapping);
                if (!this.advertiseUDPEndpoints) continue;
                endpoints.add(NetUtils.cloneMappingForProtocol(mapping, "pbrpcu"));
            }
        }
        DIR.AddressMappingSet.Builder amsb = DIR.AddressMappingSet.newBuilder();
        for (DIR.AddressMapping.Builder builder : endpoints) {
            amsb.addMappings(builder);
        }
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.net, this, "Registering the following address mappings for the service:", new Object[0]);
            for (DIR.AddressMapping addressMapping : amsb.getMappingsList()) {
                Logging.logMessage(6, Logging.Category.net, this, "%s --> %s (%s)", addressMapping.getUuid(), addressMapping.getUri(), addressMapping.getMatchNetwork());
            }
        }
        this.client.xtreemfs_address_mappings_set(null, authNone, this.uc, amsb.build());
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public String getAdvertisedHostName() {
        return this.advertisedHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseOperation() throws InterruptedException {
        Object object = this.pauseLock;
        synchronized (object) {
            ++this.pauseNumberOfWaitingThreads;
            while (!this.paused) {
                try {
                    this.pauseLock.wait();
                }
                catch (InterruptedException e) {
                    --this.pauseNumberOfWaitingThreads;
                    this.pauseLock.notifyAll();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeOperation() {
        Object object = this.pauseLock;
        synchronized (object) {
            --this.pauseNumberOfWaitingThreads;
            this.pauseLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerAddressMappingRenewal() {
        this.addressMappingRenewalPending = true;
        this.addressMappingRenewalTriggered = true;
        Object object = this.updateIntervalMonitor;
        synchronized (object) {
            this.updateIntervalMonitor.notifyAll();
        }
    }

    private void enableAddressMappingRenewalSignal() {
        final HeartbeatThread hbt = this;
        try {
            Signal.handle(new Signal("USR2"), new SignalHandler(){

                @Override
                public void handle(Signal signal) {
                    if (hbt != null) {
                        hbt.triggerAddressMappingRenewal();
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            Logging.logMessage(2, this, "Could not register SignalHandler for USR2.", new Object[0]);
            Logging.logError(2, null, e);
            throw new RuntimeException("Could not register SignalHandler for USR2.", e);
        }
    }

    public static interface ServiceDataGenerator {
        public DIR.ServiceSet getServiceData();
    }
}

