/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.logging.Logging;

public class ServiceAvailability {
    public static final int DEFAULT_INITIAL_TIMEOUT = 60000;
    public static final int DEFAULT_CLEANUP_INTERVAL = 3600000;
    public static final int DEFAULT_MAX_LAST_ACCESS = 86400000;
    private final ServiceRemover removerThread;
    private ConcurrentHashMap<ServiceUUID, ServiceInfo> serviceAvailability = new ConcurrentHashMap();
    private final int initialTimeout;

    public ServiceAvailability() {
        this.initialTimeout = 60000;
        this.removerThread = new ServiceRemover(this.serviceAvailability, 86400000, 3600000);
        this.removerThread.start();
    }

    public ServiceAvailability(int initialTimeout, int maxLastAccessTime, int cleanupInterval) {
        this.initialTimeout = initialTimeout;
        this.removerThread = new ServiceRemover(this.serviceAvailability, maxLastAccessTime, cleanupInterval);
        this.removerThread.start();
    }

    public void shutdown() {
        this.removerThread.quitThread();
    }

    public boolean isServiceAvailable(ServiceUUID service) {
        if (!this.serviceAvailability.containsKey(service)) {
            this.serviceAvailability.put(service, new ServiceInfo(this.initialTimeout));
            return true;
        }
        return this.serviceAvailability.get(service).isAvailable();
    }

    public void setServiceWasNotAvailable(ServiceUUID service) {
        if (!this.serviceAvailability.containsKey(service)) {
            this.serviceAvailability.put(service, new ServiceInfo(this.initialTimeout));
        }
        this.serviceAvailability.get(service).lastAccessFailed();
    }

    private static class ServiceInfo {
        private long lastAccessTime = 0L;
        private long lastFailedAccessTime = 0L;
        private int currentTimeout;

        public ServiceInfo(int timeout) {
            this.currentTimeout = timeout;
        }

        public boolean isAvailable() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.lastFailedAccessTime + (long)this.currentTimeout <= System.currentTimeMillis();
        }

        public void lastAccessFailed() {
            this.lastFailedAccessTime = System.currentTimeMillis();
            this.currentTimeout *= 2;
        }
    }

    private class ServiceRemover
    extends Thread {
        final int cleanupInterval;
        private final int maxLastAccessTime;
        private final ConcurrentHashMap<ServiceUUID, ServiceInfo> serviceAvailability;
        boolean quit;

        public ServiceRemover(ConcurrentHashMap<ServiceUUID, ServiceInfo> serviceAvailability2, int maxLastAccessTime, int cleanupInterval) {
            super("ServiceAvailability Service-Remover");
            this.serviceAvailability = serviceAvailability2;
            this.cleanupInterval = cleanupInterval;
            this.maxLastAccessTime = maxLastAccessTime;
            this.quit = false;
        }

        public void quitThread() {
            this.quit = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.quit) {
                Iterator<ServiceInfo> serviceIt = this.serviceAvailability.values().iterator();
                while (serviceIt.hasNext()) {
                    ServiceInfo service = serviceIt.next();
                    if (System.currentTimeMillis() - service.lastAccessTime <= (long)this.maxLastAccessTime) continue;
                    serviceIt.remove();
                }
                try {
                    Thread.sleep(this.cleanupInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.lifecycle, this, "shutdown complete", new Object[0]);
            }
        }
    }
}

