/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.auth;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.xtreemfs.common.auth.AuthenticationException;
import org.xtreemfs.common.auth.AuthenticationProvider;
import org.xtreemfs.common.auth.UserCredentials;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.channels.ChannelIO;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class FederationIdX509AuthProvider
implements AuthenticationProvider {
    private static final String USER_ID = "CN";
    private static final String GROUP_ID = "O";

    @Override
    public UserCredentials getEffectiveCredentials(RPC.UserCredentials ctx, ChannelIO channel) throws AuthenticationException {
        if (channel.getAttachment() != null) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.auth, this, "using attachment...", new Object[0]);
            }
            UserCredentials creds = (UserCredentials)channel.getAttachment();
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.auth, this, "using cached creds: " + creds, new Object[0]);
            }
            return creds;
        }
        try {
            Certificate[] certs = channel.getCerts();
            if (certs.length > 0) {
                X509Certificate cert = (X509Certificate)certs[0];
                String fullDN = cert.getSubjectX500Principal().getName();
                List<String> globalUIDs = this.getNamedElements(cert.getSubjectX500Principal().getName(), USER_ID);
                String globalUID = null;
                globalUID = !globalUIDs.isEmpty() ? globalUIDs.iterator().next() : fullDN;
                List<String> globalGIDs = this.getNamedElements(cert.getSubjectX500Principal().getName(), GROUP_ID);
                if (globalGIDs.isEmpty()) {
                    globalGIDs.add(fullDN);
                }
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.auth, this, "X.509-User cert present: %s, %s", globalUID, globalGIDs);
                }
                boolean isSuperUser = false;
                UserCredentials creds = new UserCredentials(globalUID, globalGIDs, isSuperUser);
                channel.setAttachment(creds);
                return creds;
            }
            throw new AuthenticationException("no X.509-certificates present");
        }
        catch (Exception ex) {
            Logging.logUserError(3, Logging.Category.auth, this, ex);
            throw new AuthenticationException("invalid credentials " + ex);
        }
    }

    private List<String> getNamedElements(String principal, String element) {
        String[] elems = principal.split(",");
        ArrayList<String> elements = new ArrayList<String>();
        for (String elem : elems) {
            String[] kv = elem.split("=");
            if (kv.length != 2 || !kv[0].equals(element)) continue;
            elements.add(kv[1]);
        }
        return elements;
    }

    @Override
    public void initialize(boolean useSSL) throws RuntimeException {
        if (!useSSL) {
            throw new RuntimeException(this.getClass().getName() + " can only be used if SSL is enabled!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<String> readHosts(InputStream serviceCertificatesStream) {
        HashSet<String> serviceCertificates = new HashSet<String>();
        if (serviceCertificatesStream == null) {
            Logging.logMessage(4, Logging.Category.auth, FederationIdX509AuthProvider.class, "The list of privileged-certificates does not exist.", new Object[0]);
            return serviceCertificates;
        }
        InputStreamReader in = null;
        BufferedReader reader = null;
        try {
            in = new InputStreamReader(serviceCertificatesStream);
            reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                line.trim();
                if (line == null || line.equals("")) continue;
                serviceCertificates.add(line);
                Logging.logMessage(6, Logging.Category.auth, FederationIdX509AuthProvider.class, "Adding service-certificate: " + line, new Object[0]);
            }
        }
        catch (FileNotFoundException e) {
            Logging.logMessage(4, Logging.Category.auth, FederationIdX509AuthProvider.class, "The list of privileged-certificates does not exist.", new Object[0]);
        }
        catch (IOException e) {
            Logging.logMessage(4, Logging.Category.auth, FederationIdX509AuthProvider.class, "Could not parse the list of privileged-certificates.", new Object[0]);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        return serviceCertificates;
    }
}

