/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.auth;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.xtreemfs.common.auth.AuthenticationException;
import org.xtreemfs.common.auth.AuthenticationProvider;
import org.xtreemfs.common.auth.NullAuthProvider;
import org.xtreemfs.common.auth.UserCredentials;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.channels.ChannelIO;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class SimpleX509AuthProvider
implements AuthenticationProvider {
    private NullAuthProvider nullAuth;

    @Override
    public UserCredentials getEffectiveCredentials(RPC.UserCredentials ctx, ChannelIO channel) throws AuthenticationException {
        assert (this.nullAuth != null);
        if (channel.getAttachment() != null) {
            Object[] cache;
            Boolean serviceCert;
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.auth, this, "using attachment...", new Object[0]);
            }
            if ((serviceCert = (Boolean)(cache = (Object[])channel.getAttachment())[0]).booleanValue()) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.auth, this, "service cert...", new Object[0]);
                }
                return this.nullAuth.getEffectiveCredentials(ctx, channel);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.auth, this, "using cached creds: " + cache[1], new Object[0]);
            }
            return (UserCredentials)cache[1];
        }
        try {
            Certificate[] certs = channel.getCerts();
            if (certs.length > 0) {
                X509Certificate cert = (X509Certificate)certs[0];
                String fullDN = cert.getSubjectX500Principal().getName();
                String commonName = this.getNameElement(cert.getSubjectX500Principal().getName(), "CN");
                if (commonName.startsWith("host/") || commonName.startsWith("xtreemfs-service/")) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.auth, this, "X.509-host cert present", new Object[0]);
                    }
                    channel.setAttachment(new Object[]{new Boolean(true)});
                    return this.nullAuth.getEffectiveCredentials(ctx, null);
                }
                String globalUID = fullDN;
                String globalGID = this.getNameElement(cert.getSubjectX500Principal().getName(), "OU");
                ArrayList<String> gids = new ArrayList<String>(1);
                gids.add(globalGID);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.auth, this, "X.509-User cert present: %s, %s", globalUID, globalGID);
                }
                boolean isSuperUser = globalGID.contains("xtreemfs-admin");
                UserCredentials creds = new UserCredentials(globalUID, gids, isSuperUser);
                channel.setAttachment(new Object[]{new Boolean(false), creds});
                return creds;
            }
            throw new AuthenticationException("no X.509-certificates present");
        }
        catch (Exception ex) {
            Logging.logUserError(3, Logging.Category.auth, this, ex);
            throw new AuthenticationException("invalid credentials " + ex);
        }
    }

    private String getNameElement(String principal, String element) {
        String[] elems;
        for (String elem : elems = principal.split(",")) {
            String[] kv = elem.split("=");
            if (kv.length != 2 || !kv[0].equals(element)) continue;
            return kv[1];
        }
        return null;
    }

    @Override
    public void initialize(boolean useSSL) throws RuntimeException {
        if (!useSSL) {
            throw new RuntimeException(this.getClass().getName() + " can only be used if SSL is enabled!");
        }
        this.nullAuth = new NullAuthProvider();
        this.nullAuth.initialize(useSSL);
    }
}

