/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.BenchmarkFailedException;
import org.xtreemfs.common.benchmark.BenchmarkResult;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.Volume;
import org.xtreemfs.foundation.logging.Logging;

abstract class AbstractBenchmark
implements Callable<BenchmarkResult> {
    static volatile boolean cancelled = false;
    final int requestSize;
    final long benchmarkSize;
    final Volume volume;
    final AdminClient client;
    final BenchmarkConfig config;
    final VolumeManager volumeManager;

    AbstractBenchmark(long benchmarkSize, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        this.client = client;
        this.benchmarkSize = benchmarkSize;
        this.volume = volumeManager.getNextVolume();
        this.config = config;
        this.requestSize = config.getChunkSizeInBytes();
        this.volumeManager = volumeManager;
        cancelled = false;
    }

    BenchmarkResult runBenchmark() throws Exception {
        String shortClassname = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        Logging.logMessage(6, Logging.Category.tool, this, "Starting %s on volume %s", shortClassname, this.volume.getVolumeName());
        byte[] data = new byte[this.requestSize];
        long numberOfRequests = this.benchmarkSize / (long)this.requestSize;
        long before = System.currentTimeMillis();
        long requestCounter = this.performIO(data, numberOfRequests);
        long after = System.currentTimeMillis();
        if (this.benchmarkSize != requestCounter) {
            throw new BenchmarkFailedException("Data written does not equal the requested size");
        }
        double timeInSec = (double)(after - before) / 1000.0;
        BenchmarkResult result = new BenchmarkResult(timeInSec, this.benchmarkSize, requestCounter);
        this.finalizeBenchmark();
        Logging.logMessage(6, Logging.Category.tool, this, "Finished %s", shortClassname);
        return result;
    }

    abstract void prepareBenchmark() throws Exception;

    abstract long performIO(byte[] var1, long var2) throws IOException;

    abstract void finalizeBenchmark() throws Exception;

    public static void cancel() {
        cancelled = true;
    }

    @Override
    public BenchmarkResult call() throws Exception {
        return this.runBenchmark();
    }
}

