/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xtreemfs.common.benchmark.Controller;
import org.xtreemfs.common.config.PolicyContainer;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class BenchmarkConfig
extends ServiceConfig {
    private static final ServiceConfig.Parameter[] benchmarkParameter = new ServiceConfig.Parameter[]{ServiceConfig.Parameter.DEBUG_LEVEL, ServiceConfig.Parameter.DEBUG_CATEGORIES, ServiceConfig.Parameter.DIRECTORY_SERVICE, ServiceConfig.Parameter.USE_SSL, ServiceConfig.Parameter.SERVICE_CREDS_FILE, ServiceConfig.Parameter.SERVICE_CREDS_PASSPHRASE, ServiceConfig.Parameter.SERVICE_CREDS_CONTAINER, ServiceConfig.Parameter.TRUSTED_CERTS_FILE, ServiceConfig.Parameter.TRUSTED_CERTS_CONTAINER, ServiceConfig.Parameter.TRUSTED_CERTS_PASSPHRASE, ServiceConfig.Parameter.TRUST_MANAGER, ServiceConfig.Parameter.USE_GRID_SSL_MODE, ServiceConfig.Parameter.ADMIN_PASSWORD, ServiceConfig.Parameter.BASEFILE_SIZE_IN_BYTES, ServiceConfig.Parameter.FILESIZE, ServiceConfig.Parameter.USERNAME, ServiceConfig.Parameter.GROUP, ServiceConfig.Parameter.OSD_SELECTION_POLICIES, ServiceConfig.Parameter.REPLICATION_POLICY, ServiceConfig.Parameter.REPLICATION_FACTOR, ServiceConfig.Parameter.CHUNK_SIZE_IN_BYTES, ServiceConfig.Parameter.STRIPE_SIZE_IN_BYTES, ServiceConfig.Parameter.STRIPE_SIZE_SET, ServiceConfig.Parameter.STRIPE_WIDTH, ServiceConfig.Parameter.STRIPE_WIDTH_SET, ServiceConfig.Parameter.NO_CLEANUP, ServiceConfig.Parameter.NO_CLEANUP_VOLUMES, ServiceConfig.Parameter.NO_CLEANUP_BASEFILE, ServiceConfig.Parameter.OSD_CLEANUP};
    private Options options;
    private Map<String, String> policyAttributes;
    private SSLOptions sslOptions = null;

    private BenchmarkConfig(Properties props, Options options, Map<String, String> policyAttributes) {
        super(props);
        this.read();
        this.options = options;
        this.policyAttributes = policyAttributes;
    }

    private void setDefaults() {
        super.setDefaults(benchmarkParameter);
    }

    private void read() {
        for (ServiceConfig.Parameter param : benchmarkParameter) {
            this.parameter.put(param, this.readParameter(param));
        }
    }

    public static ServiceConfig.Parameter[] getBenchmarkParameter() {
        return benchmarkParameter;
    }

    public void setStripeSizeInBytes(Integer size) {
        this.parameter.put(ServiceConfig.Parameter.STRIPE_SIZE_IN_BYTES, size);
    }

    public void setStripeWidth(Integer size) {
        this.parameter.put(ServiceConfig.Parameter.STRIPE_WIDTH, size);
    }

    public Long getBasefileSizeInBytes() {
        return (Long)this.parameter.get((Object)ServiceConfig.Parameter.BASEFILE_SIZE_IN_BYTES);
    }

    public Integer getFilesize() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.FILESIZE);
    }

    public String getUsername() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.USERNAME);
    }

    public String getGroup() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.GROUP);
    }

    public RPC.UserCredentials getUserCredentials() {
        return RPC.UserCredentials.newBuilder().setUsername((String)this.parameter.get((Object)ServiceConfig.Parameter.USERNAME)).addGroups((String)this.parameter.get((Object)ServiceConfig.Parameter.USERNAME)).build();
    }

    public Options getOptions() {
        return this.options;
    }

    public SSLOptions getSslOptions() throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.isUsingSSL() && null == this.sslOptions) {
            this.sslOptions = new SSLOptions(new FileInputStream(this.getServiceCredsFile()), this.getServiceCredsPassphrase(), this.getServiceCredsContainer(), new FileInputStream(this.getTrustedCertsFile()), this.getTrustedCertsPassphrase(), this.getTrustedCertsContainer(), false, this.isGRIDSSLmode(), this.getSSLProtocolString(), new PolicyContainer(this).getTrustManager());
        }
        return this.sslOptions;
    }

    public String getOsdSelectionPolicies() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.OSD_SELECTION_POLICIES);
    }

    public Map<String, String> getPolicyAttributes() {
        return this.policyAttributes;
    }

    public String getReplicationPolicy() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.REPLICATION_POLICY);
    }

    public Integer getReplicationFactor() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.REPLICATION_FACTOR);
    }

    public Integer getChunkSizeInBytes() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.CHUNK_SIZE_IN_BYTES);
    }

    public Integer getStripeSizeInBytes() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.STRIPE_SIZE_IN_BYTES);
    }

    public Integer getStripeSizeInKiB() {
        return this.getStripeSizeInBytes() / 1024;
    }

    public Boolean isStripeSizeSet() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.STRIPE_SIZE_SET);
    }

    public Integer getStripeWidth() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.STRIPE_WIDTH);
    }

    public Boolean isStripeWidthSet() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.STRIPE_WIDTH_SET);
    }

    public Boolean isNoCleanup() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.NO_CLEANUP);
    }

    public Boolean isNoCleanupVolumes() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.NO_CLEANUP_VOLUMES);
    }

    public Boolean isNoCleanupBasefile() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.NO_CLEANUP_BASEFILE);
    }

    public Boolean isOsdCleanup() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.OSD_CLEANUP);
    }

    public String[] getDirAddresses() {
        InetSocketAddress[] directoryServices = this.getDirectoryServices();
        String[] dirAddresses = new String[directoryServices.length];
        for (int i = 0; i < dirAddresses.length; ++i) {
            dirAddresses[i] = directoryServices[i].getAddress().getHostAddress() + ":" + directoryServices[i].getPort();
        }
        return dirAddresses;
    }

    public RPC.Auth getAuth() {
        RPC.Auth auth;
        if (this.getAdminPassword().equals("")) {
            auth = RPCAuthentication.authNone;
        } else {
            RPC.AuthPassword password = RPC.AuthPassword.newBuilder().setPassword(this.getAdminPassword()).build();
            auth = RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_PASSWORD).setAuthPasswd(password).build();
        }
        return auth;
    }

    public static ConfigBuilder newBuilder() {
        return new ConfigBuilder();
    }

    public static class ConfigBuilder {
        private Properties props = new Properties();
        private ServiceConfig parent;
        private Map<String, String> policyAttributes = new HashMap<String, String>();
        private Options options = new Options();

        private ConfigBuilder() {
        }

        public ConfigBuilder setBasefileSizeInBytes(long basefileSizeInBytes) {
            if (basefileSizeInBytes < 1L) {
                throw new IllegalArgumentException("basefileSizeInBytes < 1 not allowed");
            }
            this.props.setProperty(ServiceConfig.Parameter.BASEFILE_SIZE_IN_BYTES.getPropertyString(), Long.toString(basefileSizeInBytes));
            return this;
        }

        public ConfigBuilder setFilesize(int filesize) {
            if (filesize < 1) {
                throw new IllegalArgumentException("filesize < 1 not allowed");
            }
            this.props.setProperty(ServiceConfig.Parameter.FILESIZE.getPropertyString(), Integer.toString(filesize));
            return this;
        }

        public ConfigBuilder setUserName(String userName) {
            if (userName.isEmpty()) {
                throw new IllegalArgumentException("Empty username not allowed");
            }
            this.props.setProperty(ServiceConfig.Parameter.USERNAME.getPropertyString(), userName);
            return this;
        }

        public ConfigBuilder setGroup(String group) {
            if (group.isEmpty()) {
                throw new IllegalArgumentException("Empty group name not allowed");
            }
            this.props.setProperty(ServiceConfig.Parameter.USERNAME.getPropertyString(), group);
            return this;
        }

        public ConfigBuilder setAdminPassword(String adminPassword) {
            this.props.setProperty(ServiceConfig.Parameter.ADMIN_PASSWORD.getPropertyString(), adminPassword);
            return this;
        }

        public ConfigBuilder setDirAddress(String dirAddress) {
            return this.setDirAddresses(new String[]{dirAddress});
        }

        public ConfigBuilder setDirAddresses(String[] dirAddresses) {
            int i = -1;
            for (String dirAddress : dirAddresses) {
                String port;
                String host;
                if (dirAddress.contains("://")) {
                    dirAddress = dirAddress.split("://", 2)[1];
                }
                if (dirAddress.endsWith("/")) {
                    dirAddress = dirAddress.substring(0, dirAddress.length() - 1);
                }
                try {
                    host = dirAddress.split(":")[0];
                    port = dirAddress.split(":")[1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("DIR Address needs to contain a host and a port, separated by \":\" (was: \"" + dirAddress + "\").");
                }
                if (dirAddresses.length == 1 || -1 == i) {
                    this.props.setProperty("dir_service.host", host);
                    this.props.setProperty("dir_service.port", port);
                } else {
                    this.props.setProperty("dir_service." + i + ".host", host);
                    this.props.setProperty("dir_service." + i + ".port", port);
                }
                ++i;
            }
            return this;
        }

        public ConfigBuilder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public ConfigBuilder setSslOptions(boolean useSSL, boolean useGridSSL, String serviceCredsFile, String serviceCredsPass, String trustedCAsFile, String trustedCAsPass) {
            this.props.setProperty(ServiceConfig.Parameter.USE_SSL.getPropertyString(), Boolean.toString(useSSL));
            this.props.setProperty(ServiceConfig.Parameter.USE_GRID_SSL_MODE.getPropertyString(), Boolean.toString(useGridSSL));
            this.props.setProperty(ServiceConfig.Parameter.SERVICE_CREDS_FILE.getPropertyString(), serviceCredsFile);
            this.props.setProperty(ServiceConfig.Parameter.SERVICE_CREDS_PASSPHRASE.getPropertyString(), serviceCredsPass);
            this.props.setProperty(ServiceConfig.Parameter.SERVICE_CREDS_CONTAINER.getPropertyString(), "PKCS12");
            this.props.setProperty(ServiceConfig.Parameter.TRUSTED_CERTS_FILE.getPropertyString(), trustedCAsFile);
            this.props.setProperty(ServiceConfig.Parameter.TRUSTED_CERTS_CONTAINER.getPropertyString(), "JKS");
            this.props.setProperty(ServiceConfig.Parameter.TRUSTED_CERTS_PASSPHRASE.getPropertyString(), trustedCAsPass);
            return this;
        }

        public ConfigBuilder setOsdSelectionPolicies(String policies) {
            this.props.setProperty(ServiceConfig.Parameter.OSD_SELECTION_POLICIES.getPropertyString(), policies);
            return this;
        }

        public ConfigBuilder setPolicyAttribute(String attribute, String value) {
            this.policyAttributes.put(attribute, value);
            return this;
        }

        public ConfigBuilder setSelectOsdsByUuid(String uuids) {
            String key = ServiceConfig.Parameter.OSD_SELECTION_POLICIES.getPropertyString();
            String osdSelectionPolicies = this.props.getProperty(key);
            if (null == osdSelectionPolicies) {
                this.props.setProperty(key, "1002");
            } else {
                this.props.setProperty(key, osdSelectionPolicies + ",1002");
            }
            this.policyAttributes.put("1002.uuids", uuids);
            return this;
        }

        public ConfigBuilder setReplicationPolicy(String policy) {
            this.props.setProperty(ServiceConfig.Parameter.REPLICATION_POLICY.getPropertyString(), policy);
            return this;
        }

        public ConfigBuilder setReplicationFactor(int replicationFactor) {
            this.props.setProperty(ServiceConfig.Parameter.REPLICATION_FACTOR.getPropertyString(), Integer.toString(replicationFactor));
            return this;
        }

        public ConfigBuilder setChunkSizeInBytes(int chunkSizeInBytes) {
            this.props.setProperty(ServiceConfig.Parameter.CHUNK_SIZE_IN_BYTES.getPropertyString(), Integer.toString(chunkSizeInBytes));
            return this;
        }

        public ConfigBuilder setStripeSizeInBytes(int stripeSizeInBytes) {
            this.props.setProperty(ServiceConfig.Parameter.STRIPE_SIZE_IN_BYTES.getPropertyString(), Integer.toString(stripeSizeInBytes));
            this.props.setProperty(ServiceConfig.Parameter.STRIPE_SIZE_SET.getPropertyString(), Boolean.toString(true));
            return this;
        }

        public ConfigBuilder setStripeWidth(int stripeWidth) {
            this.props.setProperty(ServiceConfig.Parameter.STRIPE_WIDTH.getPropertyString(), Integer.toString(stripeWidth));
            this.props.setProperty(ServiceConfig.Parameter.STRIPE_WIDTH_SET.getPropertyString(), Boolean.toString(true));
            return this;
        }

        public ConfigBuilder setNoCleanup() {
            this.props.setProperty(ServiceConfig.Parameter.NO_CLEANUP.getPropertyString(), Boolean.toString(true));
            return this;
        }

        public ConfigBuilder setNoCleanupVolumes() {
            this.props.setProperty(ServiceConfig.Parameter.NO_CLEANUP_VOLUMES.getPropertyString(), Boolean.toString(true));
            return this;
        }

        public ConfigBuilder setNoCleanupBasefile() {
            this.props.setProperty(ServiceConfig.Parameter.NO_CLEANUP_BASEFILE.getPropertyString(), Boolean.toString(true));
            return this;
        }

        public ConfigBuilder setOsdCleanup() {
            this.props.setProperty(ServiceConfig.Parameter.OSD_CLEANUP.getPropertyString(), Boolean.toString(true));
            return this;
        }

        public ConfigBuilder setParent(ServiceConfig parent) {
            this.parent = parent;
            return this;
        }

        public BenchmarkConfig build() throws Exception {
            this.verifyNoCleanup();
            if (null != this.parent) {
                this.mergeParent();
            }
            if (null == this.props.getProperty("dir_service.host")) {
                String[] dirAddresses = Controller.getDefaultDir();
                if (null != dirAddresses) {
                    this.setDirAddresses(dirAddresses);
                } else {
                    this.setDirAddresses(new String[]{"127.0.0.1:32638"});
                }
            }
            BenchmarkConfig config = new BenchmarkConfig(this.props, this.options, this.policyAttributes);
            config.setDefaults();
            return config;
        }

        private void verifyNoCleanup() {
            boolean noCleanupBasefile = Boolean.parseBoolean(this.props.getProperty(ServiceConfig.Parameter.NO_CLEANUP_BASEFILE.getPropertyString()));
            boolean noCleanup = Boolean.parseBoolean(this.props.getProperty(ServiceConfig.Parameter.NO_CLEANUP.getPropertyString()));
            boolean noCleanupVolumes = Boolean.parseBoolean(this.props.getProperty(ServiceConfig.Parameter.NO_CLEANUP_VOLUMES.getPropertyString()));
            if (noCleanupBasefile && !noCleanup && !noCleanupVolumes) {
                throw new IllegalArgumentException("noCleanupBasefile only works with noCleanup or noCleanupVolumes");
            }
        }

        private void mergeParent() {
            HashMap<String, String> parentParameters = this.parent.toHashMap();
            for (Map.Entry<String, String> parentEntry : parentParameters.entrySet()) {
                String parentKey = parentEntry.getKey();
                String parentValue = parentEntry.getValue();
                if (null != this.props.getProperty(parentKey)) continue;
                Class parentClass = ServiceConfig.Parameter.getParameterFromString(parentKey).getPropertyClass();
                if (parentClass == InetSocketAddress.class) {
                    this.setAddressSocketProperty(parentKey, parentValue);
                    continue;
                }
                this.props.setProperty(parentKey, parentValue);
            }
        }

        private void setAddressSocketProperty(String parentKey, String parentValue) {
            String pattern = "[a-z]*/[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+:[0-9]+";
            if (!parentValue.matches(pattern)) {
                throw new IllegalArgumentException("Unknown address format for DIR adress [was: " + parentValue + ". allowed: [hostname]/]");
            }
            String address = parentValue.split("/")[1];
            String hostIP = address.split(":")[0];
            String port = address.split(":")[1];
            this.props.setProperty(parentKey, hostIP);
            this.props.setProperty(parentKey.replace("host", "port"), port);
        }
    }
}

