/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import org.xtreemfs.common.benchmark.AbstractBenchmark;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.BenchmarkUtils;
import org.xtreemfs.common.benchmark.FilebasedReadBenchmark;
import org.xtreemfs.common.benchmark.FilebasedWriteBenchmark;
import org.xtreemfs.common.benchmark.RandomReadBenchmark;
import org.xtreemfs.common.benchmark.RandomWriteBenchmark;
import org.xtreemfs.common.benchmark.SequentialReadBenchmark;
import org.xtreemfs.common.benchmark.SequentialWriteBenchmark;
import org.xtreemfs.common.benchmark.UnalignedSequentialWriteBenchmark;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;

class BenchmarkFactory {
    BenchmarkFactory() {
    }

    static AbstractBenchmark createBenchmark(long size, BenchmarkUtils.BenchmarkType benchmarkType, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        AbstractBenchmark benchmark = null;
        switch (benchmarkType) {
            case SEQ_WRITE: {
                benchmark = new SequentialWriteBenchmark(size, config, client, volumeManager);
                break;
            }
            case SEQ_UNALIGNED_WRITE: {
                benchmark = new UnalignedSequentialWriteBenchmark(size, config, client, volumeManager);
                break;
            }
            case SEQ_READ: {
                benchmark = new SequentialReadBenchmark(size, config, client, volumeManager);
                break;
            }
            case RAND_WRITE: {
                benchmark = new RandomWriteBenchmark(size, config, client, volumeManager);
                break;
            }
            case RAND_READ: {
                benchmark = new RandomReadBenchmark(size, config, client, volumeManager);
                break;
            }
            case FILES_WRITE: {
                benchmark = new FilebasedWriteBenchmark(size, config, client, volumeManager);
                break;
            }
            case FILES_READ: {
                benchmark = new FilebasedReadBenchmark(size, config, client, volumeManager);
            }
        }
        return benchmark;
    }
}

