/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import org.xtreemfs.common.benchmark.BenchmarkUtils;

public class BenchmarkResult
implements Comparable<BenchmarkResult> {
    private BenchmarkUtils.BenchmarkType benchmarkType;
    private int numberOfReadersOrWriters;
    private double timeInSec;
    private long requestedSize;
    private long actualSize;
    private boolean failed;
    private Throwable error;

    public BenchmarkResult(double timeInSec, long requestedSize, long actualSize) {
        this.timeInSec = timeInSec;
        this.requestedSize = requestedSize;
        this.actualSize = actualSize;
        this.failed = false;
    }

    public BenchmarkResult(double timeInSec, long actualSize, int numberOfReadersOrWriters, BenchmarkUtils.BenchmarkType benchmarkType) {
        this.benchmarkType = benchmarkType;
        this.numberOfReadersOrWriters = numberOfReadersOrWriters;
        this.timeInSec = timeInSec;
        this.actualSize = actualSize;
    }

    public BenchmarkResult(Throwable error) {
        this.failed = true;
        this.error = error;
    }

    void setBenchmarkType(BenchmarkUtils.BenchmarkType benchmarkType) {
        this.benchmarkType = benchmarkType;
    }

    void setNumberOfReadersOrWriters(int numberOfReadersOrWriters) {
        this.numberOfReadersOrWriters = numberOfReadersOrWriters;
    }

    public BenchmarkUtils.BenchmarkType getBenchmarkType() {
        return this.benchmarkType;
    }

    public int getNumberOfReadersOrWriters() {
        return this.numberOfReadersOrWriters;
    }

    public double getTimeInSec() {
        return this.timeInSec;
    }

    public long getRequestedSize() {
        return this.requestedSize;
    }

    public long getActualSize() {
        return this.actualSize;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isWriteBenchmark() {
        return this.benchmarkType == BenchmarkUtils.BenchmarkType.SEQ_WRITE || this.benchmarkType == BenchmarkUtils.BenchmarkType.RAND_WRITE || this.benchmarkType == BenchmarkUtils.BenchmarkType.FILES_WRITE;
    }

    public boolean isReadBenchmark() {
        return this.benchmarkType == BenchmarkUtils.BenchmarkType.SEQ_READ || this.benchmarkType == BenchmarkUtils.BenchmarkType.RAND_READ || this.benchmarkType == BenchmarkUtils.BenchmarkType.FILES_READ;
    }

    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public int compareTo(BenchmarkResult otherResult) {
        return this.benchmarkType.toString().compareTo(otherResult.benchmarkType.toString());
    }
}

