/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.util.LinkedList;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.Client;
import org.xtreemfs.common.libxtreemfs.ClientFactory;
import org.xtreemfs.foundation.logging.Logging;

class ClientManager {
    private LinkedList<AdminClient> clients = new LinkedList();
    private BenchmarkConfig config;

    ClientManager(BenchmarkConfig config) {
        this.config = config;
    }

    AdminClient getNewClient() throws Exception {
        AdminClient client = ClientFactory.createAdminClient(this.config.getDirAddresses(), this.config.getUserCredentials(), this.config.getSslOptions(), this.config.getOptions());
        this.clients.add(client);
        client.start();
        return client;
    }

    void shutdownClients() {
        for (AdminClient client : this.clients) {
            this.tryShutdownOfClient(client);
        }
        Logging.logMessage(6, Logging.Category.tool, ClientManager.class, "Shutting down %s clients", this.clients.size());
    }

    private void tryShutdownOfClient(Client client) {
        try {
            client.shutdown();
        }
        catch (Throwable e) {
            Logging.logMessage(4, Logging.Category.tool, ClientManager.class, "Error while shutting down clients", new Object[0]);
            Logging.logError(4, ClientManager.class, e);
        }
    }
}

