/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.xtreemfs.common.benchmark.AbstractBenchmark;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.BenchmarkFactory;
import org.xtreemfs.common.benchmark.BenchmarkFailedException;
import org.xtreemfs.common.benchmark.BenchmarkResult;
import org.xtreemfs.common.benchmark.BenchmarkUtils;
import org.xtreemfs.common.benchmark.ClientManager;
import org.xtreemfs.common.benchmark.UncaughtExceptionHandlerBenchmark;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.utils.DefaultDirConfig;

public class Controller {
    private BenchmarkConfig config;
    private ClientManager clientManager;
    private VolumeManager volumeManager;
    private ThreadPoolExecutor threadPool;

    public Controller(BenchmarkConfig config) throws Exception {
        this.config = config;
        this.clientManager = new ClientManager(config);
        this.volumeManager = new VolumeManager(config, this.clientManager.getNewClient());
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandlerBenchmark(this));
    }

    public void setupVolumes(String ... volumeNames) throws Exception {
        if (volumeNames.length < 1) {
            throw new IllegalArgumentException("Number of volumes < 1");
        }
        this.volumeManager.openVolumes(volumeNames);
    }

    public void setupDefaultVolumes(int numberOfVolumes) throws Exception {
        if (numberOfVolumes < 1) {
            throw new IllegalArgumentException("Number of volumes < 1");
        }
        this.volumeManager.createDefaultVolumes(numberOfVolumes);
    }

    public ArrayList<BenchmarkResult> startSequentialWriteBenchmark(long size, int numberOfThreads) throws Exception {
        this.verifySizesAndThreads(size, numberOfThreads, BenchmarkUtils.BenchmarkType.SEQ_WRITE);
        return this.startBenchmark(size, numberOfThreads, BenchmarkUtils.BenchmarkType.SEQ_WRITE);
    }

    public ArrayList<BenchmarkResult> startUnalignedSequentialWriteBenchmark(long size, int numberOfThreads) throws Exception {
        this.verifySizesAndThreads(size, numberOfThreads, BenchmarkUtils.BenchmarkType.SEQ_UNALIGNED_WRITE);
        return this.startBenchmark(size, numberOfThreads, BenchmarkUtils.BenchmarkType.SEQ_UNALIGNED_WRITE);
    }

    public ArrayList<BenchmarkResult> startSequentialReadBenchmark(long size, int numberOfThreads) throws Exception {
        this.verifySizesAndThreads(size, numberOfThreads, BenchmarkUtils.BenchmarkType.SEQ_READ);
        return this.startBenchmark(size, numberOfThreads, BenchmarkUtils.BenchmarkType.SEQ_READ);
    }

    public ArrayList<BenchmarkResult> startRandomWriteBenchmark(long size, int numberOfThreads) throws Exception {
        this.verifySizesAndThreads(size, numberOfThreads, BenchmarkUtils.BenchmarkType.RAND_WRITE);
        return this.startBenchmark(size, numberOfThreads, BenchmarkUtils.BenchmarkType.RAND_WRITE);
    }

    public ArrayList<BenchmarkResult> startRandomReadBenchmark(long size, int numberOfThreads) throws Exception {
        this.verifySizesAndThreads(size, numberOfThreads, BenchmarkUtils.BenchmarkType.RAND_READ);
        return this.startBenchmark(size, numberOfThreads, BenchmarkUtils.BenchmarkType.RAND_READ);
    }

    public ArrayList<BenchmarkResult> startFilebasedWriteBenchmark(long size, int numberOfThreads) throws Exception {
        this.verifySizesAndThreads(size, numberOfThreads, BenchmarkUtils.BenchmarkType.FILES_WRITE);
        return this.startBenchmark(size, numberOfThreads, BenchmarkUtils.BenchmarkType.FILES_WRITE);
    }

    public ArrayList<BenchmarkResult> startFilebasedReadBenchmark(long size, int numberOfThreads) throws Exception {
        this.verifySizesAndThreads(size, numberOfThreads, BenchmarkUtils.BenchmarkType.FILES_READ);
        return this.startBenchmark(size, numberOfThreads, BenchmarkUtils.BenchmarkType.FILES_READ);
    }

    public void tryConnection() throws Exception {
        try {
            this.clientManager.getNewClient().getServiceByType(DIR.ServiceType.SERVICE_TYPE_OSD);
        }
        catch (Exception e) {
            Logging.logMessage(3, Logging.Category.tool, Controller.class, "Failed to establish connection to DIR server.", new Object[0]);
            throw e;
        }
    }

    public static String[] getDefaultDir() {
        DefaultDirConfig cfg = null;
        try {
            cfg = new DefaultDirConfig();
            String[] dirAddresses = cfg.getDirectoryServices();
            return dirAddresses;
        }
        catch (IOException e) {
            Logging.logMessage(6, Logging.Category.tool, Controller.class, "Could not access or find Default DIR Config in %s. Using default (localhost).", "/etc/xos/xtreemfs/default_dir");
            return null;
        }
    }

    public void teardown() throws Exception {
        this.deleteVolumesAndFiles();
        if (this.config.isOsdCleanup().booleanValue()) {
            this.volumeManager.cleanupOSD();
        }
        this.shutdownClients();
        this.shutdownThreadPool();
    }

    private void verifySizesAndThreads(long size, int threads, BenchmarkUtils.BenchmarkType type) {
        if (type == BenchmarkUtils.BenchmarkType.SEQ_READ || type == BenchmarkUtils.BenchmarkType.SEQ_WRITE) {
            if (size % (long)(this.config.getStripeSizeInBytes() * this.config.getStripeWidth()) != 0L) {
                throw new IllegalArgumentException("size of " + (Object)((Object)type) + " must satisfy: size mod (stripeSize * stripeWidth) == 0");
            }
            if (size < (long)this.config.getChunkSizeInBytes().intValue()) {
                throw new IllegalArgumentException("Chunksize < size of " + (Object)((Object)type));
            }
        }
        if (type == BenchmarkUtils.BenchmarkType.RAND_READ || type == BenchmarkUtils.BenchmarkType.RAND_WRITE) {
            if (this.config.getBasefileSizeInBytes() < size) {
                throw new IllegalArgumentException("Basefile < size of " + (Object)((Object)type));
            }
            if (size < (long)this.config.getChunkSizeInBytes().intValue()) {
                throw new IllegalArgumentException("Chunksize < size of " + (Object)((Object)type));
            }
        }
        if ((type == BenchmarkUtils.BenchmarkType.FILES_WRITE || type == BenchmarkUtils.BenchmarkType.FILES_READ) && size % (long)this.config.getFilesize().intValue() != 0L) {
            throw new IllegalArgumentException("Size of " + (Object)((Object)type) + " must satisfy: size mod filesize == 0");
        }
        if (this.volumeManager.getVolumes().size() < threads) {
            throw new IllegalArgumentException("Less volumes than parallel threads");
        }
    }

    private ArrayList<BenchmarkResult> startBenchmark(long size, int numberOfThreads, BenchmarkUtils.BenchmarkType benchmarkType) throws Exception {
        this.checkThreadPool(numberOfThreads);
        ExecutorCompletionService<BenchmarkResult> completionService = new ExecutorCompletionService<BenchmarkResult>(this.threadPool);
        ArrayList<Future<BenchmarkResult>> futures = new ArrayList<Future<BenchmarkResult>>();
        for (int i = 0; i < numberOfThreads; ++i) {
            AbstractBenchmark benchmark = BenchmarkFactory.createBenchmark(size, benchmarkType, this.config, this.clientManager.getNewClient(), this.volumeManager);
            benchmark.prepareBenchmark();
            Future<BenchmarkResult> future = completionService.submit(benchmark);
            futures.add(future);
        }
        ArrayList<BenchmarkResult> results = this.awaitCompletion(numberOfThreads, completionService, futures);
        for (BenchmarkResult res : results) {
            res.setBenchmarkType(benchmarkType);
            res.setNumberOfReadersOrWriters(numberOfThreads);
        }
        this.volumeManager.reset();
        return results;
    }

    private void checkThreadPool(int numberOfThreads) throws InterruptedException {
        if (null == this.threadPool) {
            this.threadPool = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        } else if (this.threadPool.getPoolSize() != numberOfThreads) {
            this.threadPool.setCorePoolSize(numberOfThreads);
            this.threadPool.setMaximumPoolSize(numberOfThreads);
        }
    }

    private ArrayList<BenchmarkResult> awaitCompletion(int numberOfThreads, CompletionService<BenchmarkResult> completionService, ArrayList<Future<BenchmarkResult>> futures) throws Exception {
        ArrayList<BenchmarkResult> results = new ArrayList<BenchmarkResult>(numberOfThreads);
        Throwable exception = null;
        for (int i = 0; i < numberOfThreads; ++i) {
            try {
                Future<BenchmarkResult> benchmarkResultFuture = completionService.take();
                futures.remove(benchmarkResultFuture);
                BenchmarkResult result = benchmarkResultFuture.get();
                results.add(result);
                continue;
            }
            catch (ExecutionException e) {
                Logging.logMessage(3, Logging.Category.tool, this, "An exception occurred within an benchmark task.", new Object[0]);
                Logging.logError(3, this, e.getCause());
                for (Future<BenchmarkResult> future : futures) {
                    future.cancel(true);
                }
                AbstractBenchmark.cancel();
                exception = e;
                continue;
            }
            catch (CancellationException e) {
                Logging.logMessage(6, Logging.Category.tool, this, "Benchmark task has been canceled due to an exception in another benchmark task.", new Object[0]);
            }
        }
        if (null != exception) {
            throw new BenchmarkFailedException(exception.getCause());
        }
        return results;
    }

    void deleteVolumesAndFiles() {
        if (!this.config.isNoCleanup().booleanValue() && !this.config.isNoCleanupVolumes().booleanValue()) {
            this.volumeManager.deleteCreatedFiles();
            this.volumeManager.deleteCreatedVolumes();
        } else if (!this.config.isNoCleanup().booleanValue()) {
            this.volumeManager.deleteCreatedFiles();
        }
    }

    void shutdownClients() {
        this.clientManager.shutdownClients();
    }

    void shutdownThreadPool() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }
}

