/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import java.util.Random;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.FilebasedBenchmark;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

class FilebasedReadBenchmark
extends FilebasedBenchmark {
    private String[] filenames;

    FilebasedReadBenchmark(long size, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        super(size, config, client, volumeManager);
    }

    @Override
    void prepareBenchmark() throws Exception {
        this.filenames = this.volumeManager.getRandomFilelistForVolume(this.volume, this.benchmarkSize);
    }

    @Override
    long performIO(byte[] data, long numberOfBlocks) throws IOException {
        long numberOfFilesToRead = this.benchmarkSize / (long)this.filesize;
        int filenamesSize = this.filenames.length;
        long byteCounter = 0L;
        Random random = new Random();
        int flags = GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber();
        for (long i = 0L; !cancelled && i < numberOfFilesToRead; ++i) {
            String filename = this.filenames[random.nextInt(filenamesSize)];
            FileHandle fileHandle = this.volume.openFile(this.config.getUserCredentials(), filename, flags);
            if (this.filesize <= this.requestSize) {
                random.nextBytes(data);
                byteCounter += (long)fileHandle.read(this.config.getUserCredentials(), data, this.filesize, 0L);
            } else {
                for (long j = 0L; j < (long)(this.filesize / this.requestSize); ++j) {
                    long nextOffset = j * (long)this.requestSize;
                    assert (nextOffset >= 0L) : "Offset < 0 not allowed";
                    byteCounter += (long)fileHandle.read(this.config.getUserCredentials(), data, this.requestSize, nextOffset);
                }
            }
            fileHandle.close();
        }
        return byteCounter;
    }

    @Override
    void finalizeBenchmark() throws Exception {
    }
}

