/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.FilebasedBenchmark;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

class FilebasedWriteBenchmark
extends FilebasedBenchmark {
    private LinkedList<String> filenames = new LinkedList();

    FilebasedWriteBenchmark(long size, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        super(size, config, client, volumeManager);
    }

    @Override
    void prepareBenchmark() throws Exception {
    }

    @Override
    long performIO(byte[] data, long numberOfBlocks) throws IOException {
        long numberOfFiles = this.benchmarkSize / (long)this.filesize;
        long byteCounter = 0L;
        Random random = new Random();
        int flags = GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber();
        for (long i = 0L; !cancelled && i < numberOfFiles; ++i) {
            FileHandle fileHandle = this.volume.openFile(this.config.getUserCredentials(), "benchmarks/randomBenchmark/benchFile" + i, flags, 511);
            this.filenames.add("benchmarks/randomBenchmark/benchFile" + i);
            if (this.filesize <= this.requestSize) {
                random.nextBytes(data);
                byteCounter += (long)fileHandle.write(this.config.getUserCredentials(), data, this.filesize, 0L);
            } else {
                for (long j = 0L; j < (long)(this.filesize / this.requestSize); ++j) {
                    long nextOffset = j * (long)this.requestSize;
                    assert (nextOffset >= 0L) : "Offset < 0 not allowed";
                    random.nextBytes(data);
                    byteCounter += (long)fileHandle.write(this.config.getUserCredentials(), data, this.requestSize, nextOffset);
                }
            }
            fileHandle.close();
        }
        return byteCounter;
    }

    @Override
    void finalizeBenchmark() throws Exception {
        this.volumeManager.setRandomFilelistForVolume(this.volume, this.filenames);
        this.volumeManager.addCreatedFiles(this.volume, this.filenames);
    }
}

