/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.util.LinkedList;
import java.util.Random;
import org.xtreemfs.common.benchmark.AbstractBenchmark;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

abstract class RandomOffsetbasedBenchmark
extends AbstractBenchmark {
    static final int RANDOM_IO_BLOCKSIZE = 4096;
    final long sizeOfBasefile;
    static final String BASFILE_FILENAME = "benchmarks/basefile";

    RandomOffsetbasedBenchmark(long size, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        super(size, config, client, volumeManager);
        this.sizeOfBasefile = config.getBasefileSizeInBytes();
    }

    @Override
    void prepareBenchmark() throws Exception {
        if (this.basefileDoesNotExists()) {
            this.createBasefile();
        }
    }

    @Override
    void finalizeBenchmark() {
    }

    long convertTo4KiBBlocks(long numberOfBlocks) {
        return numberOfBlocks * (long)this.requestSize / 4096L;
    }

    long generateNextRandomOffset() {
        long nextOffset = Math.round(Math.random() * (double)(this.sizeOfBasefile - 4096L));
        assert (nextOffset >= 0L) : "Offset < 0. Offset: " + nextOffset + " Basefilesize: " + this.sizeOfBasefile;
        assert (nextOffset <= this.sizeOfBasefile - 4096L) : " Offset > Filesize. Offset: " + nextOffset + "Basefilesize: " + this.sizeOfBasefile;
        return nextOffset;
    }

    boolean basefileDoesNotExists() throws Exception {
        try {
            FileHandle fileHandle = this.volume.openFile(this.config.getUserCredentials(), BASFILE_FILENAME, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber());
            long fileSizeInBytes = fileHandle.getAttr(this.config.getUserCredentials()).getSize();
            fileHandle.close();
            return this.sizeOfBasefile != fileSizeInBytes;
        }
        catch (PosixErrorException e) {
            Logging.logMessage(6, Logging.Category.tool, this, "No basefile found.", new Object[0]);
            return true;
        }
    }

    private void createBasefile() throws Exception {
        Logging.logMessage(6, Logging.Category.tool, this, "Start creating a basefile of size %s bytes.", this.sizeOfBasefile);
        long numberOfBlocks = this.sizeOfBasefile / (long)this.requestSize;
        Random random = new Random();
        int flags = GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_TRUNC.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber();
        FileHandle fileHandle = this.volume.openFile(this.config.getUserCredentials(), BASFILE_FILENAME, flags, 511);
        long byteCounter = 0L;
        byte[] data = new byte[this.requestSize];
        for (long j = 0L; j < numberOfBlocks; ++j) {
            long nextOffset = j * (long)this.requestSize;
            assert (nextOffset >= 0L) : "Offset < 0 not allowed";
            random.nextBytes(data);
            byteCounter += (long)fileHandle.write(this.config.getUserCredentials(), data, this.requestSize, nextOffset);
        }
        fileHandle.close();
        assert (byteCounter == this.sizeOfBasefile) : " Error while writing the basefile for the random io benchmark";
        this.addBasefileToCreatedFiles();
        Logging.logMessage(6, Logging.Category.tool, this, "Basefile written. Size %s Bytes.", byteCounter);
    }

    private void addBasefileToCreatedFiles() throws Exception {
        if (!this.config.isNoCleanupBasefile().booleanValue()) {
            LinkedList<String> createdFiles = new LinkedList<String>();
            createdFiles.add(BASFILE_FILENAME);
            this.volumeManager.addCreatedFiles(this.volume, createdFiles);
        }
    }
}

