/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.common.benchmark;

import java.io.IOException;
import java.util.Random;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.RandomOffsetbasedBenchmark;
import org.xtreemfs.common.benchmark.VolumeManager;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

class RandomWriteBenchmark
extends RandomOffsetbasedBenchmark {
    RandomWriteBenchmark(long size, BenchmarkConfig config, AdminClient client, VolumeManager volumeManager) throws Exception {
        super(size, config, client, volumeManager);
    }

    @Override
    long performIO(byte[] data, long numberOfBlocks) throws IOException {
        Random random = new Random();
        numberOfBlocks = this.convertTo4KiBBlocks(numberOfBlocks);
        long byteCounter = 0L;
        int flags = GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_WRONLY.getNumber();
        for (long j = 0L; !cancelled && j < numberOfBlocks; ++j) {
            FileHandle fileHandle = this.volume.openFile(this.config.getUserCredentials(), "benchmarks/basefile", flags, 511);
            long nextOffset = this.generateNextRandomOffset();
            random.nextBytes(data);
            byteCounter += (long)fileHandle.write(this.config.getUserCredentials(), data, 4096, nextOffset);
            fileHandle.close();
        }
        return byteCounter;
    }
}

